package cn.venny.qiniu.service;

import java.io.InputStream;

/**
 * @author : Vick C
 * @version : v1.0
 * 2020/6/19
 */
public interface QiNiuUploadService {

    /**
     * 上传文件
     * @param key 文件上传唯一键值
     * @param in  文件流
     */
    void upload(String key, InputStream in);

    /**
     * 上传文件
     * @param data 文件字节数组
     * @param key  文件上传唯一键值
     */
    void upload(final byte[] data, final String key);

    /**
     * 文件下载
     * @param key 文件上传唯一键值
     * @return 文件下载的url
     */
    String download(String key);

    /**
     * w
     * 文件下载
     * @param key    文件上传唯一键值
     * @param expire 下载url过期时间
     * @return 文件下载的url
     */
    String download(String key, long expire);

    /**
     * 共有空间下载
     * @param key 文件上传唯一键值
     * @return 下载地址
     */
    String publicDownload(String key);

    /**
     * 删除文件
     * @param key 文件上传唯一键值
     */
    void delete(String key);

    /**
     * 获取token
     * @return token
     */
    String getToken();
}
