/*
 * Decompiled with CFR 0.152.
 */
package cn.venny.qiniu.service.impl;

import cn.venny.qiniu.properties.QiNiuProperties;
import cn.venny.qiniu.service.QiNiuUploadService;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Response;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import java.io.InputStream;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultQiNiuUploadServiceImpl
implements QiNiuUploadService {
    public static Logger log = LoggerFactory.getLogger(QiNiuUploadService.class);
    private static final String CHINESE_PATTERN = "[\u4e00-\u9fa5|\uff01|\uff0c|\u3002|\uff08|\uff09|\u300a|\u300b|\u201c|\u201d|\uff1f|\uff1a|\uff1b|\u3010|\u3011]";
    @Autowired
    private Auth auth;
    @Autowired
    private QiNiuProperties properties;
    @Autowired
    private UploadManager uploadManager;
    @Autowired
    private BucketManager bucketManager;

    @Override
    public boolean upload(String finalKey, InputStream in, Long fileSize) {
        try {
            Response response = this.uploadManager.put(in, fileSize.longValue(), finalKey, this.auth.uploadToken(this.properties.getBucket()), new StringMap(), null, true);
            if (log.isDebugEnabled()) {
                log.debug("upload {},fileSize:{},response:{}", new Object[]{finalKey, fileSize, response});
            }
            return Objects.nonNull(response) && 200 == response.statusCode;
        }
        catch (QiniuException e) {
            log.error("upload image/video to qi niu cloud has error", (Throwable)e);
            return false;
        }
    }

    public boolean upload(byte[] data, String key) {
        try {
            Response response = this.uploadManager.put(data, key, this.auth.uploadToken(this.properties.getBucket()), new StringMap(), null, true);
            if (log.isDebugEnabled()) {
                log.debug("upload {},fileSize:{},response:{}", new Object[]{key, data.length, response});
            }
            return Objects.nonNull(response) && 200 == response.statusCode;
        }
        catch (QiniuException e) {
            log.error("upload image/video to qi niu cloud has error", (Throwable)e);
            return false;
        }
    }

    @Override
    public String download(String key) {
        return this.download(key, 3600L);
    }

    @Override
    public String download(String key, long expire) {
        String domainOfBucket = this.properties.getCname();
        String publicUrl = String.format("%s/%s", domainOfBucket, key);
        String finalUrl = this.auth.privateDownloadUrl(publicUrl, expire);
        if (log.isDebugEnabled()) {
            log.debug("the file url is : {}", (Object)finalUrl);
        }
        return finalUrl;
    }

    @Override
    public boolean delete(String key) {
        try {
            Response deleteResponse = this.bucketManager.delete(this.properties.getBucket(), key);
            if (log.isDebugEnabled()) {
                log.debug("delete file {} response {}", (Object)key, (Object)deleteResponse);
            }
            return Objects.nonNull(deleteResponse) && 200 == deleteResponse.statusCode;
        }
        catch (QiniuException e) {
            log.error("delete file {} has error", (Object)key, (Object)e);
            return false;
        }
    }

    @Override
    public String getToken() {
        return this.auth.uploadToken(this.properties.getBucket());
    }
}

