package cn.venny.qiniu.service.impl;

import cn.venny.qiniu.properties.QiNiuProperties;
import cn.venny.qiniu.service.QiNiuUploadService;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Response;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.InputStream;
import java.util.Objects;

/**
 * @author : Vick C
 * @version : v1.0
 * 2020/6/19
 */
@Service
public class DefaultQiNiuUploadServiceImpl implements QiNiuUploadService {

    /** 日志 */
    public static Logger log = LoggerFactory.getLogger(QiNiuUploadService.class);
    private static final String CHINESE_PATTERN = "[\u4E00-\u9FA5|\uFF01|\uFF0C|\u3002|\uFF08|\uFF09|\u300A|\u300B|\u201C|\u201D|\uFF1F|\uFF1A|\uFF1B|\u3010|\u3011]";

    @Autowired
    private Auth auth;
    @Autowired
    private QiNiuProperties properties;
    @Autowired
    private UploadManager uploadManager;
    @Autowired
    private BucketManager bucketManager;

    @Override
    public boolean upload(String finalKey, InputStream in, Long fileSize) {
        try {
            Response response = uploadManager.put(in, fileSize, finalKey, auth.uploadToken(properties.getBucket()), new StringMap(), null, true);
            if (log.isDebugEnabled()) {
                log.debug("upload {},fileSize:{},response:{}", finalKey, fileSize, response);
            }
            return Objects.nonNull(response) && 200 == response.statusCode;
        } catch (QiniuException e) {
            log.error("upload image/video to qi niu cloud has error", e);
        }
        return false;
    }

    /**
     * update image or video to qiniu
     * @param data the byte array
     * @param key  the unique key
     * @return success return true
     */
    public boolean upload(final byte[] data, final String key) {
        try {
            Response response = uploadManager.put(data, key, auth.uploadToken(properties.getBucket()), new StringMap(), null, true);
            if (log.isDebugEnabled()) {
                log.debug("upload {},fileSize:{},response:{}", key, data.length, response);
            }
            return Objects.nonNull(response) && 200 == response.statusCode;
        } catch (QiniuException e) {
            log.error("upload image/video to qi niu cloud has error", e);
        }
        return false;
    }

    @Override
    public String download(String key) {
        return download(key, 3600);
    }

    @Override
    public String download(String key, long expire) {
        // 绑定域名
        String domainOfBucket = properties.getCname();
        String publicUrl = String.format("%s/%s", domainOfBucket, key);
        String finalUrl = auth.privateDownloadUrl(publicUrl, expire);
        if (log.isDebugEnabled()) {
            log.debug("the file url is : {}", finalUrl);
        }
        return finalUrl;
    }

    @Override
    public boolean delete(String key) {
        try {
            Response deleteResponse = bucketManager.delete(properties.getBucket(), key);
            if (log.isDebugEnabled()) {
                log.debug("delete file {} response {}", key, deleteResponse);
            }
            return Objects.nonNull(deleteResponse) && 200 == deleteResponse.statusCode;
        } catch (QiniuException e) {
            log.error("delete file {} has error", key, e);
        }
        return false;
    }

    @Override
    public String getToken() {
        return auth.uploadToken(properties.getBucket());
    }
}
