package cn.venny.qiniu.service;

import java.io.InputStream;

/**
 * @author : Vick C
 * @version : v1.0
 * 2020/6/19
 */
public interface QiNiuUploadService {

    /**
     * 上传文件
     * @param key      文件上传唯一键值
     * @param in       文件流
     * @param fileSize 文件大小
     * @return 上传结果
     */
    boolean upload(String key, InputStream in, Long fileSize);

    /**
     * 文件下载
     * @param key 文件上传唯一键值
     * @return 文件下载的url
     */
    String download(String key);

    /**
     * w
     * 文件下载
     * @param key    文件上传唯一键值
     * @param expire 下载url过期时间
     * @return 文件下载的url
     */
    String download(String key, long expire);

    /**
     * 删除文件
     * @param key 文件上传唯一键值
     * @return 删除结果
     */
    boolean delete(String key);

    /**
     * 获取token
     * @return token
     */
    String getToken();
}
