package cn.venny.qiniu.service.impl;

import cn.venny.qiniu.properties.QiNiuProperties;
import cn.venny.qiniu.service.QiNiuUploadService;
import cn.venny.qiniu.enums.FileEnum;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Response;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.InputStream;
import java.util.Objects;

/**
 * @author : Vick C
 * @version : v1.0
 * 2020/6/19
 */
@Service
public class DefaultQiNiuUploadServiceImpl implements QiNiuUploadService {

    /** 日志 */
    public static Logger log = LoggerFactory.getLogger(QiNiuUploadService.class);
    private static final String CHINESE_PATTERN = "[\u4E00-\u9FA5|\uFF01|\uFF0C|\u3002|\uFF08|\uFF09|\u300A|\u300B|\u201C|\u201D|\uFF1F|\uFF1A|\uFF1B|\u3010|\u3011]";

    @Value("${spring.profiles.active}")
    private String profiles;
    @Autowired
    private Auth auth;
    @Autowired
    private QiNiuProperties properties;
    @Autowired
    private UploadManager uploadManager;
    @Autowired
    private BucketManager bucketManager;

    @Override
    public boolean upload(FileEnum fileEnum, String key, InputStream in, Long fileSize) {
        if (fileEnum == null) {
            throw new RuntimeException("file type must not be null");
        }

        try {
            String finalKey = getPathFileName(fileEnum, key);

            Response response = uploadManager.put(in, fileSize, finalKey, auth.uploadToken(properties.getBucket()), new StringMap(), null, true);

            log.info("upload {} qi niu fileName:{},fileSize:{},response:{}", finalKey, key, fileSize, response);
            return Objects.nonNull(response) && 200 == response.statusCode;
        } catch (QiniuException e) {
            log.info("upload image/video to qi niu yun has error", e);
        }
        return false;
    }

    @Override
    public String download(FileEnum fileEnum, String key) {
        String fillName = getPathFileName(fileEnum, key);
        // 绑定域名
        String domainOfBucket = properties.getCname();
        String publicUrl = String.format("%s/%s", domainOfBucket, fillName);
        String finalUrl = auth.privateDownloadUrl(publicUrl, 3600);

        log.info("the file url is : {}", finalUrl);
        return finalUrl;
    }

    @Override
    public boolean delete(FileEnum fileEnum, String key) {
        String finalName = getPathFileName(fileEnum, key);

        try {
            Response deleteResponse = bucketManager.delete(properties.getBucket(), finalName);
            log.info("delete file {} response {}", key, deleteResponse);

            return Objects.nonNull(deleteResponse) && 200 == deleteResponse.statusCode;
        } catch (QiniuException e) {
            log.info("delete file {} has error", key, e);
        }
        return false;
    }

    private String getPathFileName(FileEnum fileEnum, String key) {
        return profiles + "/" + fileEnum.getCode() + "/" + key;
    }
}
