package cn.venny.qiniu.service;

import cn.venny.qiniu.enums.FileEnum;

import java.io.InputStream;

/**
 * @author : Vick C
 * @version : v1.0
 * 2020/6/19
 */
public interface QiNiuUploadService {

    /**
     * 上传文件
     * @param fileEnum 文件类型
     * @param key      文件上传唯一键值
     * @param in       文件流
     * @param fileSize 文件大小
     * @return 上传结果
     */
    boolean upload(FileEnum fileEnum, String key, InputStream in, Long fileSize);

    /**
     * 文件下载
     * @param fileEnum 文件类型
     * @param key      文件上传唯一键值
     * @return 文件下载的url
     */
    String download(FileEnum fileEnum, String key);

    /**
     * 删除文件
     * @param fileEnum 文件类型
     * @param key      文件上传唯一键值
     * @return 删除结果
     */
    boolean delete(FileEnum fileEnum, String key);
}
