package cn.venny.qiniu.config;

import cn.venny.qiniu.annotation.EnableQiNiu;
import cn.venny.qiniu.properties.QiNiuProperties;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Region;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

/**
 * @author : Vick C
 * @version : v1.0
 * 2020/6/19
 */
@org.springframework.context.annotation.Configuration
@ConditionalOnBean(annotation = EnableQiNiu.class)
@EnableConfigurationProperties(QiNiuProperties.class)
public class QiNiuAutoConfiguration {

    @Bean
    public Region getRegion() {
        return Region.autoRegion();
    }

    @Bean
    public Configuration getConfiguration(Region region) {
        return new Configuration(region);
    }

    @Bean
    public UploadManager getUploadManager(Configuration configuration) {
        return new UploadManager(configuration);
    }

    @Bean
    public Auth getAuth(QiNiuProperties properties) {
        return Auth.create(properties.getAccessKey(), properties.getAccessKeySecret());
    }

    @Bean
    public BucketManager getBucketManager(QiNiuProperties properties, Configuration configuration) {
        return new BucketManager(getAuth(properties), configuration);
    }

}
