/*
 * Decompiled with CFR 0.152.
 */
package cn.venny.qiniu.service.impl;

import cn.venny.qiniu.enums.FileEnum;
import cn.venny.qiniu.properties.QiNiuProperties;
import cn.venny.qiniu.service.QiNiuUploadService;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Response;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import java.io.InputStream;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DefaultQiNiuUploadServiceImpl
implements QiNiuUploadService {
    public static Logger log = LoggerFactory.getLogger(QiNiuUploadService.class);
    private static final String CHINESE_PATTERN = "[\u4e00-\u9fa5|\uff01|\uff0c|\u3002|\uff08|\uff09|\u300a|\u300b|\u201c|\u201d|\uff1f|\uff1a|\uff1b|\u3010|\u3011]";
    @Value(value="${spring.profiles.active}")
    private String profiles;
    @Autowired
    private Auth auth;
    @Autowired
    private QiNiuProperties properties;
    @Autowired
    private UploadManager uploadManager;
    @Autowired
    private BucketManager bucketManager;

    @Override
    public boolean upload(FileEnum fileEnum, String key, InputStream in, Long fileSize) {
        if (fileEnum == null) {
            throw new RuntimeException("file type must not be null");
        }
        try {
            String finalKey = this.getPathFileName(fileEnum, key);
            Response response = this.uploadManager.put(in, fileSize.longValue(), key, this.auth.uploadToken(this.properties.getBucket()), new StringMap(), null, true);
            log.info("upload {} qi niu fileName:{},fileSize:{},response:{}", new Object[]{finalKey, key, fileSize, response});
            return Objects.nonNull(response) && 200 == response.statusCode;
        }
        catch (QiniuException e) {
            log.info("upload image/video to qi niu yun has error", (Throwable)e);
            return false;
        }
    }

    @Override
    public String download(FileEnum fileEnum, String key) {
        String fillName = this.getPathFileName(fileEnum, key);
        String domainOfBucket = this.properties.getCname();
        String publicUrl = String.format("%s/%s", domainOfBucket, fillName);
        String finalUrl = this.auth.privateDownloadUrl(publicUrl, 3600L);
        log.info("the file url is : {}", (Object)finalUrl);
        return finalUrl;
    }

    @Override
    public boolean delete(FileEnum fileEnum, String key) {
        String finalName = this.getPathFileName(fileEnum, key);
        try {
            Response deleteResponse = this.bucketManager.delete(this.properties.getBucket(), finalName);
            log.info("delete file {} response {}", (Object)key, (Object)deleteResponse);
            return Objects.nonNull(deleteResponse) && 200 == deleteResponse.statusCode;
        }
        catch (QiniuException e) {
            log.info("delete file {} has error", (Object)key, (Object)e);
            return false;
        }
    }

    private String getPathFileName(FileEnum fileEnum, String key) {
        String path = FileEnum.IMAGE.equals(key) ? fileEnum.getCode() : FileEnum.VIDEO.getCode();
        return this.profiles + "/" + path + "/" + key;
    }
}

