/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.websocket;

import cn.veasion.project.websocket.AbstractWebSocketAuthenticationHandler;
import cn.veasion.project.websocket.AbstractWebSocketServerHandler;
import cn.veasion.project.websocket.ClientEventPublisher;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http.cors.CorsConfigBuilder;
import io.netty.handler.codec.http.cors.CorsHandler;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.FileInputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyStore;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketServer {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean checkHeartbeat = true;
    private int pingOfSeconds = 120;
    private int checkHeartbeatOfSeconds = 180;
    private int maxContentLength = 0x500000;
    private int maxFrameSize = 0x500000;
    private SSLContext sslContext;
    private ClientEventPublisher clientEventPublisher;
    private AbstractWebSocketAuthenticationHandler authenticationHandler;
    private static CorsConfig corsConfig = CorsConfigBuilder.forAnyOrigin().allowNullOrigin().allowCredentials().build();
    private transient ChannelGroup channelGroup = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    private transient Map<String, Channel> channelMap = new ConcurrentHashMap<String, Channel>();

    public ChannelFuture start(String websocketPath, int port, int workThread, AbstractWebSocketServerHandler handler) throws Exception {
        return this.start(websocketPath, port, 1, workThread, handler);
    }

    public ChannelFuture start(String websocketPath, int port, int bossThread, int workThread, AbstractWebSocketServerHandler handler) throws Exception {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(bossThread, (ThreadFactory)new DefaultThreadFactory("bossGroup"));
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(workThread <= 0 ? NettyRuntime.availableProcessors() * 2 : workThread, (ThreadFactory)new DefaultThreadFactory("workerGroup"));
        return this.start(websocketPath, port, (EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelFuture start(final String websocketPath, int port, EventLoopGroup bossGroup, EventLoopGroup workerGroup, final AbstractWebSocketServerHandler handler) throws Exception {
        handler.setWebSocketServer(this);
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)bootstrap.group(bossGroup, workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)10000)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.SO_REUSEADDR, (Object)true)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel socketChannel) throws Exception {
                    ChannelPipeline pipeline = socketChannel.pipeline();
                    if (WebSocketServer.this.sslContext != null) {
                        SSLEngine sslEngine = WebSocketServer.this.sslContext.createSSLEngine();
                        sslEngine.setUseClientMode(false);
                        pipeline.addLast(new ChannelHandler[]{new SslHandler(sslEngine)});
                    }
                    if (WebSocketServer.this.checkHeartbeat) {
                        pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(WebSocketServer.this.checkHeartbeatOfSeconds, WebSocketServer.this.pingOfSeconds, 0)});
                    }
                    pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
                    pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                    pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(WebSocketServer.this.maxContentLength)});
                    pipeline.addLast(new ChannelHandler[]{new CorsHandler(corsConfig)});
                    if (WebSocketServer.this.authenticationHandler != null) {
                        WebSocketServer.this.authenticationHandler.setWebSocketServer(WebSocketServer.this);
                        pipeline.addLast(new ChannelHandler[]{WebSocketServer.this.authenticationHandler});
                    }
                    pipeline.addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(websocketPath, null, true, WebSocketServer.this.maxFrameSize, 10000L)});
                    pipeline.addLast(new ChannelHandler[]{handler});
                }
            });
            this.log.info("\u6b63\u5728\u542f\u52a8Netty...");
            ChannelFuture channelFuture = bootstrap.bind((SocketAddress)new InetSocketAddress(port)).sync();
            String protocol = this.sslContext != null ? "wss" : "ws";
            this.log.info("Netty started on port: {} ({}) with path '{}', example => {}://127.0.0.1:{}{}?token=", new Object[]{port, protocol, websocketPath, protocol, port, websocketPath});
            ChannelFuture channelFuture2 = channelFuture;
            return channelFuture2;
        }
        finally {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                bossGroup.shutdownGracefully();
                workerGroup.shutdownGracefully();
                this.log.info("Netty exit.");
            }));
        }
    }

    public void join(Channel channel) {
        Objects.requireNonNull(channel, "channel\u4e0d\u80fd\u4e3a\u7a7a");
        this.channelGroup.add((Object)channel);
        String key = WebSocketServer.channelKey(channel);
        if (key != null) {
            this.channelMap.put(key, channel);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u52a0\u5165\u5ba2\u6237\u7aef\uff0ckey={}, remoteAddress={}", (Object)key, (Object)channel.remoteAddress());
        }
        if (this.clientEventPublisher != null) {
            this.clientEventPublisher.publishEvent("join", channel, key);
        }
    }

    public void remove(Channel channel) {
        Objects.requireNonNull(channel, "channel\u4e0d\u80fd\u4e3a\u7a7a");
        this.channelGroup.remove((Object)channel);
        String key = WebSocketServer.channelKey(channel);
        if (key != null && (channel = this.channelMap.remove(key)) != null) {
            this.channelGroup.remove((Object)channel);
        }
        if (this.clientEventPublisher != null) {
            this.clientEventPublisher.publishEvent("remove", channel, key);
        }
    }

    public int getSize() {
        return this.channelMap.size();
    }

    public Channel getChannel(String key) {
        return this.channelMap.get(key);
    }

    public static String channelKey(Channel channel) {
        if (channel != null) {
            return channel.id().asShortText();
        }
        return null;
    }

    public void removeAll() {
        this.channelGroup.clear();
        this.channelMap.clear();
        this.log.debug("\u79fb\u9664\u6240\u7528\u5ba2\u6237\u7aef");
    }

    public ChannelFuture sendTo(String key, WebSocketFrame msg) {
        Channel channel = this.channelMap.get(key);
        if (channel != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("\u53d1\u9001\u6d88\u606f To {} \u5ba2\u6237\u7aef: {}", (Object)key, (Object)(msg instanceof TextWebSocketFrame ? ((TextWebSocketFrame)msg).text() : msg));
            }
            return channel.writeAndFlush((Object)msg);
        }
        this.log.debug("\u53d1\u9001\u6d88\u606f To {} \u5ba2\u6237\u7aef\u6d88\u606f\u5931\u8d25\uff0c\u5ba2\u6237\u7aef\u4e0d\u5b58\u5728", (Object)key);
        return null;
    }

    public ChannelGroupFuture sendAll(WebSocketFrame msg) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u53d1\u9001\u6d88\u606f\u7ed9\u6240\u6709\u5ba2\u6237\u7aef: {}", (Object)(msg instanceof TextWebSocketFrame ? ((TextWebSocketFrame)msg).text() : msg));
        }
        return this.channelGroup.writeAndFlush((Object)msg);
    }

    public void setClientEventPublisher(ClientEventPublisher clientEventPublisher) {
        this.clientEventPublisher = clientEventPublisher;
    }

    public void setCheckHeartbeat(boolean checkHeartbeat, int pingOfSeconds, int checkHeartbeatOfSeconds) {
        this.checkHeartbeat = checkHeartbeat;
        this.pingOfSeconds = pingOfSeconds;
        this.checkHeartbeatOfSeconds = checkHeartbeatOfSeconds;
    }

    public void setAuthenticationHandler(AbstractWebSocketAuthenticationHandler authenticationHandler) {
        this.authenticationHandler = authenticationHandler;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setSslContext(String type, String path, String password) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(type);
        FileInputStream inputStream = new FileInputStream(path);
        keyStore.load(inputStream, password.toCharArray());
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, password.toCharArray());
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagerFactory.getKeyManagers(), null, null);
        this.setSslContext(sslContext);
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    public void setMaxContentLength(int maxContentLength) {
        this.maxContentLength = maxContentLength;
    }
}

