/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.websocket;

import cn.veasion.project.utils.CountDownLatchExt;
import cn.veasion.project.websocket.AbstractWebSocketClientHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class WebSocketClient {
    private int maxContentLength = 0x500000;
    private int maxFrameSize = 0x500000;
    private Map<String, Object> headers;
    private boolean checkHeartbeat;
    private Channel channel;

    public void connect(String url, AbstractWebSocketClientHandler handler) throws Exception {
        this.connect(url, handler, null);
    }

    public void connect(String url, final AbstractWebSocketClientHandler handler, Consumer<Bootstrap> bootstrapConsumer) throws Exception {
        int port;
        SslContext sslCtx;
        final URI uri = new URI(url);
        if ("wss".equalsIgnoreCase(uri.getScheme())) {
            sslCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            port = uri.getPort() == -1 ? 443 : uri.getPort();
        } else {
            sslCtx = null;
            port = uri.getPort() == -1 ? 80 : uri.getPort();
        }
        DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
        if (this.headers != null) {
            this.headers.forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).add(arg_0, arg_1));
        }
        WebSocketClientHandshaker handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)uri, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)true, (HttpHeaders)httpHeaders, (int)this.maxFrameSize);
        handler.setHandshaker(handshaker);
        NioEventLoopGroup group = new NioEventLoopGroup();
        try {
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel socketChannel) {
                    ChannelPipeline pipeline = socketChannel.pipeline();
                    if (sslCtx != null) {
                        pipeline.addLast(new ChannelHandler[]{sslCtx.newHandler(socketChannel.alloc(), uri.getHost(), port)});
                    }
                    if (WebSocketClient.this.checkHeartbeat) {
                        pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(0, 5, 0)});
                    }
                    pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
                    pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(WebSocketClient.this.maxContentLength)});
                    pipeline.addLast(new ChannelHandler[]{handler});
                }
            });
            if (bootstrapConsumer != null) {
                bootstrapConsumer.accept(bootstrap);
            }
            CountDownLatchExt countDownLatch = new CountDownLatchExt();
            bootstrap.connect(uri.getHost(), port).addListener(channelFuture -> {
                countDownLatch.setResult(channelFuture);
                countDownLatch.countDown();
            });
            countDownLatch.await(8L, TimeUnit.SECONDS);
            ChannelFuture result = (ChannelFuture)countDownLatch.getResult();
            if (!result.isSuccess()) {
                if (result.cause() != null) {
                    throw new RuntimeException("\u8fde\u63a5\u5931\u8d25", result.cause());
                }
                throw new RuntimeException("\u8fde\u63a5\u5931\u8d25");
            }
            this.channel = result.channel();
            this.channel.closeFuture().addListener(arg_0 -> WebSocketClient.lambda$connect$1((EventLoopGroup)group, arg_0));
            handshaker.handshake(this.channel);
            handler.getHandshakeFuture().await(8L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    public void setCheckHeartbeat(boolean checkHeartbeat) {
        this.checkHeartbeat = checkHeartbeat;
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }

    public void addHeader(String key, Object value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, Object>();
        }
        this.headers.put(key, value);
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    public void setMaxContentLength(int maxContentLength) {
        this.maxContentLength = maxContentLength;
    }

    public ChannelFuture writeAndFlush(byte[] bytes) {
        return this.writeAndFlush(bytes, null);
    }

    public ChannelFuture writeAndFlush(String msg) {
        return this.writeAndFlush((WebSocketFrame)new TextWebSocketFrame(msg), null);
    }

    public ChannelFuture writeAndFlush(WebSocketFrame webSocketFrame) {
        return this.writeAndFlush(webSocketFrame, null);
    }

    public ChannelFuture writeAndFlush(byte[] bytes, ChannelFutureListener channelFutureListener) {
        return this.writeAndFlush((WebSocketFrame)new BinaryWebSocketFrame(Unpooled.copiedBuffer((byte[])bytes)), channelFutureListener);
    }

    public ChannelFuture writeAndFlush(WebSocketFrame webSocketFrame, ChannelFutureListener channelFutureListener) {
        if (!this.channel.isActive()) {
            throw new RuntimeException("\u8fde\u63a5\u5df2\u65ad\u5f00\uff0c\u53d1\u9001\u6d88\u606f\u5931\u8d25");
        }
        ChannelFuture channelFuture = this.channel.writeAndFlush((Object)webSocketFrame);
        if (channelFutureListener != null) {
            channelFuture.addListener((GenericFutureListener)channelFutureListener);
        }
        return channelFuture;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public Future<?> close() throws Exception {
        ChannelFuture future = null;
        if (this.channel != null) {
            future = this.channel.close().sync();
        }
        return future;
    }

    private static /* synthetic */ void lambda$connect$1(EventLoopGroup group, Future future) throws Exception {
        group.shutdownGracefully();
    }
}

