/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.websocket;

import cn.veasion.project.websocket.WebSocketServer;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public abstract class AbstractWebSocketServerHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    protected Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected WebSocketServer webSocketServer;

    void setWebSocketServer(WebSocketServer webSocketServer) {
        this.webSocketServer = webSocketServer;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.webSocketServer.join(ctx.channel());
        ctx.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.webSocketServer.remove(ctx.channel());
        ctx.fireChannelInactive();
    }

    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame msg) {
        if (!(msg instanceof PongWebSocketFrame)) {
            this.read(ctx, msg);
        }
        if (msg instanceof PingWebSocketFrame) {
            ctx.channel().writeAndFlush((Object)new PongWebSocketFrame());
        }
    }

    protected abstract void read(ChannelHandlerContext var1, WebSocketFrame var2);

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.log.error("\u8fde\u63a5\u5f02\u5e38", cause);
        ctx.close();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent e = (IdleStateEvent)evt;
            if (e.state() == IdleState.READER_IDLE) {
                ctx.disconnect();
                ctx.close();
                this.log.debug("\u8d85\u65f6\u65ad\u5f00\u8fde\u63a5\uff1a" + WebSocketServer.channelKey(ctx.channel()));
            } else if (e.state() == IdleState.WRITER_IDLE) {
                ctx.writeAndFlush((Object)new PingWebSocketFrame());
            }
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    public void clearAll() {
        if (this.webSocketServer != null) {
            this.webSocketServer.removeAll();
        }
    }
}

