/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.websocket;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWebSocketClientHandler
extends SimpleChannelInboundHandler<Object> {
    protected Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private WebSocketClientHandshaker handshaker;
    private ChannelPromise handshakeFuture;
    protected CountDownLatch closeCountDownLatch;

    void setHandshaker(WebSocketClientHandshaker handshaker) {
        this.handshaker = handshaker;
    }

    public ChannelPromise getHandshakeFuture() {
        return this.handshakeFuture;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.handshakeFuture = ctx.newPromise();
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u5efa\u7acb\u8fde\u63a5");
        }
    }

    public void channelActive(ChannelHandlerContext ctx) {
        ctx.fireChannelActive();
        this.closeCountDownLatch = new CountDownLatch(1);
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u8fde\u63a5\u6210\u529f");
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        ctx.fireChannelInactive();
        if (this.closeCountDownLatch != null) {
            this.closeCountDownLatch.countDown();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u8fde\u63a5\u65ad\u5f00");
        }
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) {
        Channel channel = ctx.channel();
        if (!this.handshaker.isHandshakeComplete()) {
            try {
                FullHttpResponse response = (FullHttpResponse)msg;
                this.handshaker.finishHandshake(channel, response);
                this.handshakeFuture.setSuccess();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("\u63e1\u624b\u6210\u529f");
                }
            }
            catch (Exception e) {
                this.log.error("\u8fde\u63a5\u5931\u8d25", (Throwable)e);
                this.handshakeFuture.setFailure((Throwable)e);
            }
        } else if (msg instanceof PingWebSocketFrame) {
            ctx.writeAndFlush((Object)new PongWebSocketFrame());
        } else if (msg instanceof CloseWebSocketFrame) {
            channel.close();
            this.handleCloseCode(((CloseWebSocketFrame)msg).statusCode());
            if (this.log.isDebugEnabled()) {
                this.log.debug("\u8fde\u63a5\u5173\u95ed");
            }
        } else if (msg instanceof WebSocketFrame) {
            this.read(ctx, (WebSocketFrame)msg);
        } else {
            this.log.info("\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff1a" + msg);
        }
    }

    protected void handleCloseCode(int statusCode) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u8fde\u63a5\u5173\u95ed\uff0cstatusCode: " + statusCode);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent e = (IdleStateEvent)evt;
            if (e.state() == IdleState.WRITER_IDLE) {
                ctx.writeAndFlush((Object)new PingWebSocketFrame());
            }
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    protected abstract void read(ChannelHandlerContext var1, WebSocketFrame var2);

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        this.log.error("\u8fde\u63a5\u5f02\u5e38", e);
        ctx.close();
    }

    public void waitClose(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.closeCountDownLatch != null) {
            this.closeCountDownLatch.await(timeout, unit);
        }
    }
}

