/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.websocket;

import cn.veasion.project.websocket.WebSocketServer;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.FullHttpRequest;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

@ChannelHandler.Sharable
public abstract class AbstractWebSocketAuthenticationHandler
extends ChannelInboundHandlerAdapter {
    protected WebSocketServer webSocketServer;

    void setWebSocketServer(WebSocketServer webSocketServer) {
        this.webSocketServer = webSocketServer;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            boolean success;
            FullHttpRequest request = (FullHttpRequest)msg;
            String uri = request.uri();
            HashMap<String, String> params = new HashMap<String, String>();
            int idx = uri.indexOf("?");
            if (idx > -1) {
                String[] split;
                for (String param : split = uri.substring(idx + 1).split("&")) {
                    String[] p = param.split("=");
                    if (p.length == 1) continue;
                    params.put(p[0], URLDecoder.decode(p[1], "UTF-8"));
                }
                request.setUri(uri.substring(0, idx));
            }
            if (!(success = this.handleAuthentication(ctx, request, params))) {
                ctx.disconnect();
                ctx.close();
                return;
            }
        }
        ctx.fireChannelRead(msg);
    }

    protected abstract boolean handleAuthentication(ChannelHandlerContext var1, FullHttpRequest var2, Map<String, String> var3);
}

