/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.utils;

import cn.veasion.db.utils.TypeUtils;
import cn.veasion.project.utils.StringUtils;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThirdConfigUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThirdConfigUtils.class);
    public static String CHARSET = "GBK";
    public static String DEFAULT_PATH = "third.properties";
    public static String EXT_PATH_KEY = "extConfigPath";
    private static final Map<String, Set<String>> filenamePathMap = new HashMap<String, Set<String>>();
    private static final Map<String, Map<String, String>> filenameConfig = new HashMap<String, Map<String, String>>();

    public static synchronized void reload() {
        filenameConfig.clear();
        for (Map.Entry<String, Set<String>> entry : filenamePathMap.entrySet()) {
            for (String path : entry.getValue()) {
                if ("".equals(entry.getKey()) && DEFAULT_PATH.equals(path)) {
                    ThirdConfigUtils.loadDefault();
                    continue;
                }
                ThirdConfigUtils.load(entry.getKey(), path);
            }
        }
    }

    private static void loadDefault() {
        Map<String, String> config = ThirdConfigUtils.load(DEFAULT_PATH);
        if (config == null) {
            return;
        }
        String extConfigPath = config.get(EXT_PATH_KEY);
        if (StringUtils.isNotEmpty((CharSequence)extConfigPath)) {
            try {
                File file = new File(extConfigPath);
                if (!file.exists()) {
                    LOGGER.error("\u6269\u5c55\u914d\u7f6e\u4e0d\u5b58\u5728\uff1a" + extConfigPath);
                    return;
                }
                Properties ext_properties = new Properties();
                try (InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                    ext_properties.load(new InputStreamReader(is, CHARSET));
                }
                if (ext_properties.size() > 0) {
                    for (Map.Entry<Object, Object> entry : ext_properties.entrySet()) {
                        config.put(entry.getKey().toString(), entry.getValue() == null ? null : entry.getValue().toString());
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("\u52a0\u8f7d\u6269\u5c55\u914d\u7f6e\u5931\u8d25\uff1a" + extConfigPath, (Throwable)e);
            }
        }
    }

    public static synchronized Map<String, String> load(String path) {
        return ThirdConfigUtils.load("", path);
    }

    public static synchronized Map<String, String> load(String filename, String path) {
        try {
            Map config = null;
            try (InputStream is = ThirdConfigUtils.class.getClassLoader().getResourceAsStream(path);){
                if (is != null) {
                    filenamePathMap.compute(filename, (k, v) -> {
                        v = new HashSet<String>();
                        v.add(path);
                        return v;
                    });
                    config = filenameConfig.computeIfAbsent(filename, k -> new HashMap());
                    Properties properties = new Properties();
                    properties.load(new InputStreamReader(is, CHARSET));
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        String key = entry.getKey().toString();
                        String value = entry.getValue() == null ? null : entry.getValue().toString();
                        config.put(key, value);
                    }
                }
            }
            return config;
        }
        catch (Exception e) {
            LOGGER.error("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff1a" + path, (Throwable)e);
            return null;
        }
    }

    public static String getProperty(String key) {
        return ThirdConfigUtils.getFilenameProperty("", key);
    }

    public static <T> T getProperty(String key, Class<T> clazz) {
        return (T)TypeUtils.convert((Object)ThirdConfigUtils.getFilenameProperty("", key), clazz);
    }

    public static void setProperty(String key, String value) {
        ThirdConfigUtils.setFilenameProperty("", key, value);
    }

    public static String getProperty(String key, String defVal) {
        return ThirdConfigUtils.getFilenameProperty("", key, defVal);
    }

    public static String getFilenameProperty(String filename, String key) {
        Map<String, String> map = filenameConfig.get(filename);
        return map != null ? map.get(key) : null;
    }

    public static <T> T getFilenameProperty(String filename, String key, Class<T> clazz) {
        return (T)TypeUtils.convert((Object)ThirdConfigUtils.getFilenameProperty(filename, key), clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFilenameProperty(String filename, String key, String value) {
        Map<String, Map<String, String>> map = filenameConfig;
        synchronized (map) {
            Map<String, String> map2 = filenameConfig.get(filename);
            if (map2 != null) {
                map2.put(key, value);
            }
        }
    }

    public static String getFilenameProperty(String filename, String key, String defVal) {
        String property = ThirdConfigUtils.getFilenameProperty(filename, key);
        return StringUtils.isNotEmpty((CharSequence)property) ? property : defVal;
    }

    static {
        ThirdConfigUtils.loadDefault();
    }
}

