/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.utils;

import cn.veasion.project.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Base64;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class StringUtils
extends org.apache.commons.lang3.StringUtils {
    private static final char SEPARATOR = '_';

    public static String toCamelCase(String s) {
        if (s == null) {
            return null;
        }
        s = s.toLowerCase();
        StringBuilder sb = new StringBuilder(s.length());
        boolean upperCase = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '_') {
                upperCase = true;
                continue;
            }
            if (upperCase) {
                sb.append(Character.toUpperCase(c));
                upperCase = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toCapitalizeCamelCase(String s) {
        if (s == null) {
            return null;
        }
        s = StringUtils.toCamelCase(s);
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    static String toUnderScoreCase(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean upperCase = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            boolean nextUpperCase = true;
            if (i < s.length() - 1) {
                nextUpperCase = Character.isUpperCase(s.charAt(i + 1));
            }
            if (i > 0 && Character.isUpperCase(c)) {
                if (!upperCase || !nextUpperCase) {
                    sb.append('_');
                }
                upperCase = true;
            } else {
                upperCase = false;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static int ld(String str1, String str2) {
        int j;
        int i;
        int n = str1.length();
        int m = str2.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char ch1 = str1.charAt(i - 1);
            for (j = 1; j <= m; ++j) {
                char ch2 = str2.charAt(j - 1);
                int temp = ch1 == ch2 ? 0 : 1;
                d[i][j] = StringUtils.min(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + temp);
            }
        }
        return d[n][m];
    }

    private static int min(int one, int two, int three) {
        int min = one;
        if (two < min) {
            min = two;
        }
        if (three < min) {
            min = three;
        }
        return min;
    }

    public static String getIp(HttpServletRequest request) {
        String UNKNOWN = "unknown";
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        String comma = ",";
        String localhost = "127.0.0.1";
        if (ip.contains(comma)) {
            ip = ip.split(",")[0];
        }
        if (localhost.equals(ip)) {
            try {
                ip = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return ip;
    }

    public static String getLocalIp() {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface anInterface = interfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = anInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddr = inetAddresses.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr.getHostAddress();
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress.getHostAddress();
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                return "";
            }
            return jdkSuppliedAddress.getHostAddress();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static boolean matchValue(String value, String matchOper, Object matchValue) {
        try {
            switch (matchOper) {
                case "eq": {
                    return String.valueOf(matchValue).equals(value);
                }
                case "neq": {
                    return !String.valueOf(matchValue).equals(value);
                }
                case "like": {
                    return value != null && value.contains(String.valueOf(matchValue));
                }
                case "notLike": {
                    return value == null || !value.contains(String.valueOf(matchValue));
                }
                case "notNull": {
                    return StringUtils.isNotEmpty((CharSequence)value);
                }
                case "isNull": {
                    return StringUtils.isEmpty((CharSequence)value);
                }
                case "lt": 
                case "lte": 
                case "gt": 
                case "gte": {
                    if (StringUtils.isEmpty((CharSequence)value) || matchValue == null) {
                        return false;
                    }
                    if (!matchValue.toString().matches("\\d+")) {
                        matchValue = DateUtils.simpleParse(matchValue.toString());
                    }
                    if (matchValue instanceof Date) {
                        matchValue = ((Date)matchValue).getTime();
                        if (!value.matches("\\d+")) {
                            value = String.valueOf(DateUtils.simpleParse(value).getTime());
                        }
                    }
                    int compare = new BigDecimal(value).compareTo(new BigDecimal(matchValue.toString()));
                    switch (matchOper) {
                        case "lt": {
                            return compare < 0;
                        }
                        case "lte": {
                            return compare <= 0;
                        }
                        case "gt": {
                            return compare > 0;
                        }
                    }
                    return compare >= 0;
                }
                case "between": {
                    if (StringUtils.isEmpty((CharSequence)value) || matchValue == null) {
                        return false;
                    }
                    List<String> _matchValue = StringUtils.parseListValue(matchValue);
                    if (value.matches("\\d+")) {
                        BigDecimal _value = new BigDecimal(value);
                        return _value.compareTo(new BigDecimal(_matchValue.get(0))) >= 0 && _value.compareTo(new BigDecimal(_matchValue.get(1))) <= 0;
                    }
                    long _value = DateUtils.simpleParse(value).getTime();
                    return _value >= DateUtils.simpleParse(_matchValue.get(0)).getTime() && _value <= DateUtils.simpleParse(_matchValue.get(1)).getTime();
                }
                case "all": {
                    List<String> all = StringUtils.parseListValue(matchValue);
                    List<String> _all = StringUtils.parseListValue(value);
                    for (String s : all) {
                        if (_all.contains(s)) continue;
                        return false;
                    }
                    return true;
                }
                case "any": {
                    List<String> any = StringUtils.parseListValue(matchValue);
                    List<String> _any = StringUtils.parseListValue(value);
                    for (String s : any) {
                        if (!_any.contains(s)) continue;
                        return true;
                    }
                    return false;
                }
                case "notAll": {
                    List<String> notAll = StringUtils.parseListValue(matchValue);
                    List<String> _notAll = StringUtils.parseListValue(value);
                    for (String s : notAll) {
                        if (!_notAll.contains(s)) continue;
                        return false;
                    }
                    return true;
                }
                case "notAny": {
                    List<String> notAny = StringUtils.parseListValue(matchValue);
                    List<String> _notAny = StringUtils.parseListValue(value);
                    for (String s : notAny) {
                        if (_notAny.contains(s)) continue;
                        return true;
                    }
                    return false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static List<String> parseListValue(Object matchValue) {
        if (matchValue instanceof String) {
            return JSONArray.parseArray((String)matchValue.toString(), String.class);
        }
        return JSONArray.parseArray((String)JSON.toJSONString((Object)matchValue), String.class);
    }

    public static String sub(String str, int maxLength, boolean append3Point) {
        if (str == null || str.length() <= maxLength) {
            return str;
        }
        if (append3Point) {
            return str.substring(0, maxLength) + "...";
        }
        return str.substring(0, maxLength);
    }

    public static String base64Encode(byte[] data) {
        return Base64.getEncoder().encodeToString(data);
    }

    public static byte[] base64Decoder(String base64) {
        return Base64.getDecoder().decode(base64);
    }

    public static String base64EncodeWithUrl(byte[] data) {
        return StringUtils.base64Encode(data).replace("+", "-").replace("/", "_").replace("=", "");
    }

    public static byte[] base64DecoderWithUrl(String base64Url) {
        String str = base64Url.replace("-", "+").replace("_", "/");
        for (int i = 0; i < str.length() % 4; ++i) {
            str = str + "=";
        }
        return StringUtils.base64Decoder(str);
    }
}

