/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.utils;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class StringComparator
implements Comparator<String> {
    private char[] str1;
    private char[] str2;
    private int pos1;
    private int pos2;
    private int len1;
    private int len2;
    private static final Map<Character, Character> convertMap = new HashMap<Character, Character>();

    public static void addConvert(Character a, Character b) {
        convertMap.put(a, b);
    }

    @Override
    public int compare(String s1, String s2) {
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        this.str1 = this.toChars(s1);
        this.str2 = this.toChars(s2);
        this.len1 = this.str1.length;
        this.len2 = this.str2.length;
        this.pos2 = 0;
        this.pos1 = 0;
        int result = 0;
        while (result == 0 && this.pos1 < this.len1 && this.pos2 < this.len2) {
            char ch1 = this.str1[this.pos1];
            char ch2 = this.str2[this.pos2];
            result = Character.isDigit(ch1) ? (Character.isDigit(ch2) ? this.compareNumbers() : -1) : (Character.isLetter(ch1) ? (Character.isLetter(ch2) ? this.compareOther(true) : 1) : (Character.isDigit(ch2) ? 1 : (Character.isLetter(ch2) ? -1 : this.compareOther(false))));
            ++this.pos1;
            ++this.pos2;
        }
        return result == 0 ? this.len1 - this.len2 : result;
    }

    private char[] toChars(String s) {
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            chars[i] = convertMap.getOrDefault(Character.valueOf(c), Character.valueOf(c)).charValue();
        }
        return chars;
    }

    private int compareNumbers() {
        int end2;
        int end1;
        for (end1 = this.pos1 + 1; end1 < this.len1 && Character.isDigit(this.str1[end1]); ++end1) {
        }
        int fullLen1 = end1 - this.pos1;
        while (this.pos1 < end1 && this.str1[this.pos1] == '0') {
            ++this.pos1;
        }
        for (end2 = this.pos2 + 1; end2 < this.len2 && Character.isDigit(this.str2[end2]); ++end2) {
        }
        int fullLen2 = end2 - this.pos2;
        while (this.pos2 < end2 && this.str2[this.pos2] == '0') {
            ++this.pos2;
        }
        int delta = end1 - this.pos1 - (end2 - this.pos2);
        if (delta != 0) {
            return delta;
        }
        while (this.pos1 < end1 && this.pos2 < end2) {
            if ((delta = this.str1[this.pos1++] - this.str2[this.pos2++]) == 0) continue;
            return delta;
        }
        --this.pos1;
        --this.pos2;
        return fullLen2 - fullLen1;
    }

    private int compareOther(boolean isLetters) {
        char ch1 = this.str1[this.pos1];
        char ch2 = this.str2[this.pos2];
        if (ch1 == ch2) {
            return 0;
        }
        if (isLetters && (ch1 = Character.toUpperCase(ch1)) != (ch2 = Character.toUpperCase(ch2))) {
            ch1 = Character.toLowerCase(ch1);
            ch2 = Character.toLowerCase(ch2);
        }
        return ch1 - ch2;
    }

    static {
        convertMap.put(Character.valueOf('\u96f6'), Character.valueOf('0'));
        convertMap.put(Character.valueOf('\u4e00'), Character.valueOf('1'));
        convertMap.put(Character.valueOf('\u4e8c'), Character.valueOf('2'));
        convertMap.put(Character.valueOf('\u4e09'), Character.valueOf('3'));
        convertMap.put(Character.valueOf('\u56db'), Character.valueOf('4'));
        convertMap.put(Character.valueOf('\u4e94'), Character.valueOf('5'));
        convertMap.put(Character.valueOf('\u516d'), Character.valueOf('6'));
        convertMap.put(Character.valueOf('\u4e03'), Character.valueOf('7'));
        convertMap.put(Character.valueOf('\u516b'), Character.valueOf('8'));
        convertMap.put(Character.valueOf('\u4e5d'), Character.valueOf('9'));
    }
}

