/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class SpringBeanUtils
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;
    private static final Map<Class<?>, Object> CACHE_MAP;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getBean(Class<T> clazz) {
        if (CACHE_MAP.containsKey(clazz)) {
            return (T)CACHE_MAP.get(clazz);
        }
        if (applicationContext == null) {
            throw new RuntimeException("SpringBeanUtils \u7c7b applicationContext \u672a\u521d\u59cb\u5316");
        }
        Object bean = applicationContext.getBean(clazz);
        Map<Class<?>, Object> map = CACHE_MAP;
        synchronized (map) {
            CACHE_MAP.put(clazz, bean);
        }
        return (T)bean;
    }

    public static <T> T getBean(String beanName) {
        if (applicationContext == null) {
            throw new RuntimeException("SpringBeanUtils \u7c7b applicationContext \u672a\u521d\u59cb\u5316");
        }
        return (T)applicationContext.getBean(beanName);
    }

    public static <T> Map<String, T> getBeanOfType(Class<T> clazz) {
        if (applicationContext == null) {
            throw new RuntimeException("SpringBeanUtils \u7c7b applicationContext \u672a\u521d\u59cb\u5316");
        }
        return applicationContext.getBeansOfType(clazz);
    }

    public static <T> Optional<T> getBeanOfNullable(Class<T> clazz) {
        if (applicationContext == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(SpringBeanUtils.getBean(clazz));
    }

    public static <T> Optional<T> getBeanOfNullable(String beanName) {
        if (applicationContext != null && applicationContext.containsBean(beanName)) {
            return Optional.of(applicationContext.getBean(beanName));
        }
        return Optional.empty();
    }

    public static <T> T getProperties(String property, Class<T> clazz) {
        return SpringBeanUtils.getProperties(property, null, clazz);
    }

    public static <T> T getProperties(String property, T defaultValue, Class<T> clazz) {
        Object result = defaultValue;
        try {
            result = SpringBeanUtils.getBean(Environment.class).getProperty(property, clazz);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringBeanUtils.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    static {
        CACHE_MAP = new HashMap();
    }
}

