/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.utils;

import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestHolder {
    public static HttpServletRequest getHttpServletRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            return ((ServletRequestAttributes)requestAttributes).getRequest();
        }
        return null;
    }

    public static String getDomain(HttpServletRequest request) {
        int start;
        if (request == null) {
            request = RequestHolder.getHttpServletRequest();
        }
        if (request == null) {
            return null;
        }
        StringBuffer requestURL = request.getRequestURL();
        int end = requestURL.indexOf("/", start = requestURL.indexOf("//") + 2);
        String domain = end > -1 ? requestURL.substring(start, end) : requestURL.substring(start);
        return domain.split(":")[0];
    }

    public static String getDomainUrl(HttpServletRequest request) {
        String _url = request.getRequestURL().toString();
        boolean isHttps = _url.startsWith("https") || _url.contains(":443/");
        return (isHttps ? "https://" : "http://") + RequestHolder.getDomain(request);
    }

    public static String getServerBaseUrl(HttpServletRequest request) {
        String domain;
        if (request == null) {
            request = RequestHolder.getHttpServletRequest();
        }
        if (request == null) {
            return null;
        }
        StringBuffer requestURL = request.getRequestURL();
        int end = requestURL.indexOf("/", 10);
        String string = domain = end > -1 ? requestURL.substring(0, end) : requestURL.substring(0);
        if (domain.endsWith(":443")) {
            domain = domain.replace(":443", "").replace("http://", "https://");
        }
        String contextPath = request.getContextPath() != null ? request.getContextPath() : "";
        return domain + contextPath;
    }

    public static boolean startContextPath(String contextPath) {
        HttpServletRequest httpServletRequest = RequestHolder.getHttpServletRequest();
        if (httpServletRequest == null) {
            return false;
        }
        return httpServletRequest.getContextPath().startsWith(contextPath);
    }
}

