/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.utils;

import cn.veasion.project.utils.StringUtils;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;

public class MailUtils {
    private static final int TIMEOUT_MS = 20000;

    public static void send(final MailVO mailVO) throws Exception {
        boolean auth = StringUtils.isNotEmpty((CharSequence)mailVO.getPassword());
        Properties props = new Properties();
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.smtp.host", mailVO.getHost());
        props.put("mail.smtp.auth", String.valueOf(auth));
        props.put("mail.smtp.timeout", String.valueOf(20000));
        if (mailVO.isStarttlsEnable()) {
            props.put("mail.smtp.starttls.enable", "true");
            mailVO.setSslEnable(true);
        }
        if (mailVO.isSslEnable()) {
            props.put("mail.smtp.ssl.enable", "true");
            props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.put("smtp.socketFactory.port", (Object)(mailVO.getSslPort() != null ? mailVO.getSslPort() : 465));
        }
        Session session = auth ? Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(mailVO.getUser(), mailVO.getPassword());
            }
        }) : Session.getInstance((Properties)props);
        MimeMessage msg = new MimeMessage(session);
        if (StringUtils.isNotEmpty((CharSequence)mailVO.getNickName())) {
            msg.setFrom(mailVO.getNickName() + "<" + mailVO.getUser() + ">");
        } else {
            msg.setFrom(mailVO.getUser());
        }
        msg.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(mailVO.getRecipients()));
        if (StringUtils.isNotEmpty((CharSequence)mailVO.getCc())) {
            msg.setRecipients(Message.RecipientType.CC, mailVO.getCc());
        }
        msg.setSubject(mailVO.getSubject());
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart contentPart = new MimeBodyPart();
        contentPart.setContent((Object)mailVO.getContent(), "text/html;charset=UTF-8");
        multipart.addBodyPart((BodyPart)contentPart);
        if (mailVO.getAttachment() != null) {
            MimeBodyPart attachmentBodyPart = new MimeBodyPart();
            ByteArrayDataSource source = new ByteArrayDataSource(mailVO.getAttachment(), "application/octet-stream");
            attachmentBodyPart.setDataHandler(new DataHandler((DataSource)source));
            attachmentBodyPart.setFileName(MimeUtility.encodeWord((String)mailVO.getAttachmentName()));
            multipart.addBodyPart((BodyPart)attachmentBodyPart);
        }
        msg.setContent((Multipart)multipart);
        if (mailVO.isSaveChanges()) {
            msg.saveChanges();
        }
        msg.setSentDate(new Date());
        Transport.send((Message)msg, (Address[])msg.getAllRecipients());
    }

    public static class MailVO {
        private String host;
        private String nickName;
        private String user;
        private String password;
        private boolean sslEnable;
        private boolean starttlsEnable;
        private Integer sslPort = 465;
        private String recipients;
        private String cc;
        private String subject;
        private String content;
        private byte[] attachment;
        private String attachmentName;
        private boolean saveChanges;

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public String getNickName() {
            return this.nickName;
        }

        public void setNickName(String nickName) {
            this.nickName = nickName;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public boolean isSslEnable() {
            return this.sslEnable;
        }

        public void setSslEnable(boolean sslEnable) {
            this.sslEnable = sslEnable;
        }

        public boolean isStarttlsEnable() {
            return this.starttlsEnable;
        }

        public void setStarttlsEnable(boolean starttlsEnable) {
            this.starttlsEnable = starttlsEnable;
        }

        public Integer getSslPort() {
            return this.sslPort;
        }

        public void setSslPort(Integer sslPort) {
            this.sslPort = sslPort;
        }

        public String getRecipients() {
            return this.recipients;
        }

        public void setRecipients(String recipients) {
            this.recipients = recipients;
        }

        public String getCc() {
            return this.cc;
        }

        public void setCc(String cc) {
            this.cc = cc;
        }

        public String getSubject() {
            return this.subject;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public byte[] getAttachment() {
            return this.attachment;
        }

        public void setAttachment(byte[] attachment) {
            this.attachment = attachment;
        }

        public String getAttachmentName() {
            return this.attachmentName;
        }

        public void setAttachmentName(String attachmentName) {
            this.attachmentName = attachmentName;
        }

        public boolean isSaveChanges() {
            return this.saveChanges;
        }

        public void setSaveChanges(boolean saveChanges) {
            this.saveChanges = saveChanges;
        }
    }
}

