/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.utils;

import cn.veasion.project.utils.SpringBeanUtils;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.springframework.util.StringUtils;

public class JwtUtils {
    private static Key SIGNING_KEY;

    public static String createToken(String id, String name, long ttlMillis) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", id);
        return Jwts.builder().signWith(JwtUtils.getSigningKey()).setClaims(map).setSubject(name).setIssuedAt(new Date()).setExpiration(new Date(System.currentTimeMillis() + ttlMillis)).compact();
    }

    public static Claims parseJWT(String token) {
        return (Claims)Jwts.parserBuilder().setSigningKey(JwtUtils.getSigningKey()).build().parseClaimsJws(token).getBody();
    }

    public static boolean isExpired(Claims claims) {
        try {
            return claims.getExpiration().before(new Date());
        }
        catch (ExpiredJwtException e) {
            return true;
        }
    }

    public static String getUserId(Claims claims) {
        return (String)claims.get((Object)"userId");
    }

    public static String getName(Claims claims) {
        return claims.getSubject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Key getSigningKey() {
        if (SIGNING_KEY != null) {
            return SIGNING_KEY;
        }
        Class<JwtUtils> clazz = JwtUtils.class;
        synchronized (JwtUtils.class) {
            if (SIGNING_KEY != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return SIGNING_KEY;
            }
            String jwtSecret = SpringBeanUtils.getProperties("jwtSecret", String.class);
            if (!StringUtils.hasText((String)jwtSecret)) {
                throw new RuntimeException("jwtSecret\u672a\u8bbe\u7f6e");
            }
            SIGNING_KEY = new SecretKeySpec(DatatypeConverter.parseBase64Binary((String)jwtSecret), SignatureAlgorithm.HS256.getJcaName());
            // ** MonitorExit[var0] (shouldn't be in output)
            return SIGNING_KEY;
        }
    }
}

