/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.utils;

import cn.veasion.project.utils.FileUtil;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.RGBLuminanceSource;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.HashMap;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.io.FileUtils;

public class ImageUtils {
    public static String decodeQRImage(File qrFile) throws Exception {
        BufferedImage image = ImageIO.read(qrFile);
        int width = image.getWidth();
        int height = image.getHeight();
        RGBLuminanceSource source = new RGBLuminanceSource(width, height, image.getRGB(0, 0, width, height, null, 0, width));
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
        HashMap<DecodeHintType, Object> hints = new HashMap<DecodeHintType, Object>();
        hints.put(DecodeHintType.CHARACTER_SET, "utf-8");
        hints.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
        hints.put(DecodeHintType.PURE_BARCODE, Boolean.TRUE);
        return new MultiFormatReader().decode(bitmap, hints).getText();
    }

    public static String createQRImage(String content, int width, int height) throws Exception {
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        hints.put(EncodeHintType.MARGIN, 1);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, width, height, hints);
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, bitMatrix.get(x, y) ? -16777216 : -1);
            }
        }
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)image, "png", outputStream);
            String string = Base64.getEncoder().encodeToString(outputStream.toByteArray());
            return string;
        }
    }

    public static void compress(File input, File output, long desFileSize) throws IOException {
        byte[] bytes = FileUtils.readFileToByteArray((File)input);
        bytes = ImageUtils.compressPictureForScale(bytes, desFileSize);
        if (output.exists()) {
            FileUtil.del((File)output);
        }
        FileUtils.writeByteArrayToFile((File)output, (byte[])bytes);
    }

    public static byte[] compressPictureForScale(byte[] imageBytes, long desFileSize) throws IOException {
        if (imageBytes == null || imageBytes.length <= 0 || (long)imageBytes.length <= desFileSize * 1024L) {
            return imageBytes;
        }
        long srcSize = imageBytes.length;
        double accuracy = ImageUtils.getAccuracy(srcSize / 1024L);
        while ((long)imageBytes.length > desFileSize * 1024L) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(imageBytes);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(imageBytes.length);
            Thumbnails.of((InputStream[])new InputStream[]{inputStream}).scale(accuracy).outputQuality(accuracy).toOutputStream((OutputStream)outputStream);
            imageBytes = outputStream.toByteArray();
        }
        return imageBytes;
    }

    private static double getAccuracy(long size) {
        double accuracy = size < 512L ? 0.85 : (size < 1024L ? 0.8 : (size < 2048L ? 0.7 : 0.6));
        return accuracy;
    }
}

