/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.utils;

import cn.veasion.project.utils.FileUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.util.StringUtils;

public class HttpUtils {
    public static final String CHARSET_DEFAULT = "UTF-8";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_TYPE_JSON = "application/json";
    public static final String CONTENT_TYPE_FORM_DATA = "application/x-www-form-urlencoded";
    private static final PoolingHttpClientConnectionManager CONNECTION_MANAGER = new PoolingHttpClientConnectionManager(HttpUtils.getDefaultRegistry());
    private static final int MAX_CONNECT_TIMEOUT = 8000;
    private static final int MAX_SOCKET_TIMEOUT = 90000;

    public static HttpResponse get(String url) {
        return HttpUtils.get(url, null);
    }

    public static HttpResponse get(String url, Map<String, Object> params) {
        String urlLinks = HttpUtils.getUrlLinks(params);
        if (urlLinks != null) {
            url = url.contains("?") ? url + "&" + urlLinks : url + "?" + urlLinks;
        }
        return HttpUtils.request(HttpRequest.build(url, "GET"));
    }

    public static void download(String url, File destFile) throws Exception {
        HttpRequest request = HttpRequest.build(url, "GET");
        request.setResponseHandler(entity -> {
            try {
                FileUtil.mkParentDirs((File)destFile);
                try (FileOutputStream fs = new FileOutputStream(destFile);){
                    entity.writeTo((OutputStream)fs);
                }
                return destFile;
            }
            catch (Exception e) {
                return e;
            }
        });
        HttpResponse response = HttpUtils.request(request);
        if (response.getResponse() instanceof Exception) {
            throw (Exception)response.getResponse();
        }
    }

    public static HttpResponse postJson(String url, String bodyJson) {
        HttpRequest request = HttpRequest.build(url, "POST").setBody(bodyJson);
        if (request.getHeaders() == null) {
            request.setHeaders(Collections.singletonMap(CONTENT_TYPE, CONTENT_TYPE_JSON));
        } else {
            request.getHeaders().put(CONTENT_TYPE, CONTENT_TYPE_JSON);
        }
        return HttpUtils.request(request);
    }

    public static HttpResponse postForm(String url, Map<String, Object> params) {
        String urlLinks = HttpUtils.getUrlLinks(params);
        HttpRequest request = HttpRequest.build(url, "POST").setBody(urlLinks != null ? urlLinks : "");
        if (request.getHeaders() == null) {
            request.setHeaders(Collections.singletonMap(CONTENT_TYPE, CONTENT_TYPE_FORM_DATA));
        } else {
            request.getHeaders().put(CONTENT_TYPE, CONTENT_TYPE_FORM_DATA);
        }
        return HttpUtils.request(request);
    }

    public static HttpResponse requestWithEventStream(HttpRequest request, Consumer<String> dataConsumer) {
        if (request.getMaxSocketTimeout() == null) {
            request.setMaxSocketTimeout(30000);
        }
        request.setResponseHandler(entity -> {
            StringBuilder sb = new StringBuilder();
            try (InputStream is = entity.getContent();
                 BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    sb.append(line).append("\n");
                    if (!line.startsWith("data:")) continue;
                    dataConsumer.accept(line.substring(line.startsWith("data: ") ? 6 : 5));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("eventStream \u8bf7\u6c42\u5f02\u5e38", e);
            }
            return sb.toString();
        });
        return HttpUtils.request(request);
    }

    public static String getUrlLinks(Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        try {
            Object[] sortedKeys = params.keySet().toArray(new String[0]);
            Arrays.sort(sortedKeys);
            for (Object key : sortedKeys) {
                if (key == null || ((String)key).length() == 0) continue;
                Object value = params.get(key);
                sb.append((String)key).append("=");
                if (value != null) {
                    sb.append(URLEncoder.encode(value.toString(), CHARSET_DEFAULT));
                }
                sb.append("&");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static Map<String, Object> parseUrlLinks(String params) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (params == null || params.isEmpty()) {
            return result;
        }
        for (String param : params.split("&")) {
            String[] split = param.split("=");
            String key = split[0];
            String value = "";
            if (split.length > 1) {
                value = split[1];
            }
            if (result.containsKey(key)) {
                Object o = result.get(key);
                if (o instanceof List) {
                    ((List)o).add(value);
                    continue;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(o);
                list.add(value);
                result.put(key, list);
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    public static HttpResponse request(HttpRequest request) {
        HttpRequestBase requestBase = HttpUtils.toRequest(request);
        Map<String, String> headers = request.getHeaders();
        ContentType contentType = null;
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                String key = entry.getKey();
                if (!StringUtils.hasText((String)key)) continue;
                String value = entry.getValue();
                if (CONTENT_TYPE.equalsIgnoreCase(key) && value != null) {
                    contentType = ContentType.parse((String)value);
                }
                requestBase.setHeader(key, value);
            }
        }
        HttpUtils.setBodyEntity(requestBase, contentType, request.getBody());
        try {
            HttpClient client = HttpUtils.getHttpClient(request, requestBase);
            long startTime = System.currentTimeMillis();
            org.apache.http.HttpResponse response = client.execute((HttpUriRequest)requestBase);
            HttpResponse httpResponse = new HttpResponse();
            httpResponse.setReqTime(System.currentTimeMillis() - startTime);
            httpResponse.setStatus(response.getStatusLine().getStatusCode());
            Header[] allHeaders = response.getAllHeaders();
            if (allHeaders != null && allHeaders.length > 0) {
                httpResponse.setHeaders(new HashMap<String, String>());
                for (Header header : allHeaders) {
                    httpResponse.getHeaders().put(header.getName(), header.getValue());
                }
            }
            HttpEntity entity = response.getEntity();
            if (request.responseHandler != null) {
                httpResponse.setResponse(request.responseHandler.apply(entity));
            } else {
                String charset = null;
                if (entity.getContentType() != null && entity.getContentType().getValue() != null && (contentType = ContentType.parse((String)entity.getContentType().getValue())).getCharset() != null) {
                    charset = contentType.getCharset().name();
                }
                if (charset == null) {
                    charset = CHARSET_DEFAULT;
                }
                httpResponse.setResponse(IOUtils.toString((InputStream)entity.getContent(), (String)charset));
            }
            HttpResponse httpResponse2 = httpResponse;
            return httpResponse2;
        }
        catch (Exception e) {
            requestBase.abort();
            throw new RuntimeException("\u8bf7\u6c42\u5f02\u5e38", e);
        }
        finally {
            requestBase.releaseConnection();
        }
    }

    private static void setBodyEntity(HttpRequestBase requestBase, ContentType contentType, Object body) {
        if (body != null && requestBase instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest entityRequest = (HttpEntityEnclosingRequest)requestBase;
            if (body instanceof HttpEntity) {
                entityRequest.setEntity((HttpEntity)body);
            } else if (body instanceof String) {
                entityRequest.setEntity((HttpEntity)HttpUtils.getStringEntity((String)body, contentType));
            } else if (body instanceof byte[]) {
                entityRequest.setEntity((HttpEntity)new ByteArrayEntity((byte[])body, contentType));
            } else if (body instanceof File) {
                entityRequest.setEntity((HttpEntity)new FileEntity((File)body, contentType));
            } else if (body instanceof InputStream) {
                entityRequest.setEntity((HttpEntity)new InputStreamEntity((InputStream)body, contentType));
            } else if (ContentType.APPLICATION_JSON.equals(contentType)) {
                entityRequest.setEntity((HttpEntity)HttpUtils.getStringEntity(JSON.toJSONString((Object)body), contentType));
            } else {
                entityRequest.setEntity((HttpEntity)HttpUtils.getStringEntity(body.toString(), contentType));
            }
        }
    }

    private static StringEntity getStringEntity(String body, ContentType contentType) {
        if (contentType != null && contentType.getCharset() != null) {
            return new StringEntity(body, contentType);
        }
        return new StringEntity(body, CHARSET_DEFAULT);
    }

    public static HttpRequestBase toRequest(HttpRequest request) {
        String url = request.getUrl();
        String method = request.getMethod();
        if (!StringUtils.hasText((String)url)) {
            throw new RuntimeException("url\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)method)) {
            method = "GET";
        }
        switch (method.toUpperCase()) {
            case "GET": {
                return new HttpGet(url);
            }
            case "POST": {
                return new HttpPost(url);
            }
            case "PUT": {
                return new HttpPut(url);
            }
            case "PATCH": {
                return new HttpPatch(url);
            }
            case "DELETE": {
                return new HttpDelete(url);
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u65b9\u5f0f\uff1a" + method);
    }

    private static HttpClient getHttpClient(HttpRequest req, HttpRequestBase request) {
        RequestConfig.Builder customReqConf = RequestConfig.custom();
        if (req.getMaxSocketTimeout() != null) {
            customReqConf.setSocketTimeout(req.getMaxSocketTimeout().intValue());
        } else {
            customReqConf.setSocketTimeout(90000);
        }
        customReqConf.setConnectTimeout(8000);
        customReqConf.setConnectionRequestTimeout(8000);
        request.setConfig(customReqConf.build());
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)CONNECTION_MANAGER).build();
    }

    private static Registry<ConnectionSocketFactory> getDefaultRegistry() {
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, new X509TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, new SecureRandom());
            return RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)new SSLConnectionSocketFactory(context)).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
        }
    }

    public static String toParamLinks(Map<String, Object> params, boolean encode) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuilder sb = new StringBuilder();
        try {
            for (String key : keys) {
                Object value;
                if (key == null || "".equals(key) || (value = params.get(key)) == null || "".equals(value)) continue;
                if (encode) {
                    sb.append(key).append("=").append(URLEncoder.encode(value.toString(), CHARSET_DEFAULT)).append("&");
                    continue;
                }
                sb.append(key).append("=").append(value).append("&");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("\u7f16\u7801\u5931\u8d25", e);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    static {
        CONNECTION_MANAGER.setMaxTotal(500);
        CONNECTION_MANAGER.setDefaultMaxPerRoute(100);
    }

    public static class HttpResponse
    implements Serializable {
        private int status;
        private long reqTime;
        private Object response;
        private Map<String, String> headers;

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public long getReqTime() {
            return this.reqTime;
        }

        public void setReqTime(long reqTime) {
            this.reqTime = reqTime;
        }

        public Object getResponse() {
            return this.response;
        }

        public String getResponseToString() {
            if (this.response == null) {
                return null;
            }
            return this.response instanceof String ? (String)this.response : String.valueOf(this.response);
        }

        public JSONObject getResponseToJson() {
            return JSON.parseObject((String)this.getResponseToString());
        }

        public void setResponse(Object response) {
            this.response = response;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public void setHeaders(Map<String, String> headers) {
            this.headers = headers;
        }
    }

    public static class HttpRequest
    implements Serializable {
        private String url;
        private String method;
        private Map<String, String> headers;
        private Object body;
        private Integer maxSocketTimeout;
        private Function<HttpEntity, Object> responseHandler;

        public static HttpRequest build(String url, String method) {
            HttpRequest request = new HttpRequest();
            request.url = url;
            request.method = method;
            return request;
        }

        public static HttpRequest get(String url) {
            return HttpRequest.build(url, "GET");
        }

        public static HttpRequest postJson(String url) {
            return HttpRequest.build(url, "POST").setContentType(HttpUtils.CONTENT_TYPE_JSON);
        }

        public static HttpRequest postFormData(String url) {
            return HttpRequest.build(url, "POST").setContentType(HttpUtils.CONTENT_TYPE_FORM_DATA);
        }

        public String getUrl() {
            return this.url;
        }

        public HttpRequest setUrl(String url) {
            this.url = url;
            return this;
        }

        public String getMethod() {
            return this.method;
        }

        public HttpRequest setMethod(String method) {
            this.method = method;
            return this;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public HttpRequest setHeaders(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public HttpRequest setContentType(String contentType) {
            if (this.headers == null) {
                this.headers = new HashMap<String, String>();
            }
            this.headers.put(HttpUtils.CONTENT_TYPE, contentType);
            return this;
        }

        public HttpRequest addHeaders(String key, Object value) {
            if (this.headers == null) {
                this.headers = new HashMap<String, String>();
            }
            this.headers.put(key, value != null ? value.toString() : null);
            return this;
        }

        public Object getBody() {
            return this.body;
        }

        public HttpRequest setBody(Object body) {
            this.body = body;
            return this;
        }

        public HttpRequest setMaxSocketTimeout(Integer maxSocketTimeout) {
            this.maxSocketTimeout = maxSocketTimeout;
            return this;
        }

        public Integer getMaxSocketTimeout() {
            return this.maxSocketTimeout;
        }

        public Function<HttpEntity, Object> getResponseHandler() {
            return this.responseHandler;
        }

        public HttpRequest setResponseHandler(Function<HttpEntity, Object> responseHandler) {
            this.responseHandler = responseHandler;
            return this;
        }
    }
}

