/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.utils;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.poi.excel.BigExcelWriter;
import cn.hutool.poi.excel.ExcelUtil;
import cn.veasion.project.utils.StringUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class FileUtil
extends cn.hutool.core.io.FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);
    public static final String SYS_TEM_DIR;

    public static File toFile(MultipartFile multipartFile) {
        String fileName = multipartFile.getOriginalFilename();
        String suffix = FileUtil.getExtensionName(fileName);
        if (StringUtils.isNotEmpty((CharSequence)suffix)) {
            suffix = "." + suffix;
        }
        File file = null;
        try {
            file = new File(SYS_TEM_DIR + IdUtil.simpleUUID() + suffix);
            multipartFile.transferTo(file);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return file;
    }

    public static File tempFile(String suffix) {
        if (!suffix.startsWith(".")) {
            suffix = "." + suffix;
        }
        return new File(SYS_TEM_DIR + IdUtil.simpleUUID() + suffix);
    }

    public static String getExtensionName(String filename) {
        if (filename == null) {
            return "";
        }
        int dot = filename.lastIndexOf(46);
        if (dot > -1 && dot < filename.length() - 1) {
            return filename.substring(dot + 1);
        }
        return "";
    }

    public static String getFileNameNoEx(String filename) {
        int dot;
        if (filename != null && filename.length() > 0 && (dot = filename.lastIndexOf(46)) > -1 && dot < filename.length()) {
            return filename.substring(0, dot);
        }
        return filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File inputStreamToFile(InputStream ins, String name) {
        File file = new File(SYS_TEM_DIR + name);
        if (file.exists()) {
            return file;
        }
        FileOutputStream os = null;
        try {
            int bytesRead;
            os = new FileOutputStream(file);
            int len = 8192;
            byte[] buffer = new byte[len];
            while ((bytesRead = ins.read(buffer, 0, len)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
                if (ins != null) {
                    ins.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    public static File upload(MultipartFile file, String filePath) {
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddhhmmssS");
        String name = FileUtil.getFileNameNoEx(file.getOriginalFilename());
        String suffix = FileUtil.getExtensionName(file.getOriginalFilename());
        if (StringUtils.isNotEmpty((CharSequence)suffix)) {
            suffix = "." + suffix;
        }
        String nowStr = "-" + format.format(date);
        try {
            String fileName = name + nowStr + suffix;
            String path = filePath + fileName;
            File dest = new File(path).getCanonicalFile();
            if (!dest.getParentFile().exists()) {
                dest.getParentFile().mkdirs();
            }
            file.transferTo(dest);
            return dest;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static void downloadExcel(List<Map<String, Object>> list, HttpServletResponse response) throws IOException {
        String tempPath = SYS_TEM_DIR + IdUtil.fastSimpleUUID() + ".xlsx";
        File file = new File(tempPath);
        BigExcelWriter writer = ExcelUtil.getBigWriter((File)file);
        writer.write(list, true);
        SXSSFSheet sheet = (SXSSFSheet)writer.getSheet();
        sheet.trackAllColumnsForAutoSizing();
        writer.autoSizeColumnAll();
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;filename=file.xlsx");
        ServletOutputStream out = response.getOutputStream();
        file.deleteOnExit();
        writer.flush((OutputStream)out, true);
        IoUtil.close((Closeable)out);
    }

    public static void checkSize(long maxSize, long size) {
        int len = 0xA00000;
        if (size > maxSize * (long)len) {
            throw new RuntimeException("\u6587\u4ef6\u8d85\u51fa\u89c4\u5b9a\u5927\u5c0f");
        }
    }

    public static boolean check(File file1, File file2) {
        String img1Md5 = FileUtil.getMd5(file1);
        String img2Md5 = FileUtil.getMd5(file2);
        if (img1Md5 != null) {
            return img1Md5.equals(img2Md5);
        }
        return false;
    }

    public static boolean check(String file1Md5, String file2Md5) {
        return file1Md5.equals(file2Md5);
    }

    private static byte[] getByte(File file) {
        byte[] b = new byte[(int)file.length()];
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            try {
                in.read(b);
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return b;
    }

    public static String getMd5(byte[] bytes) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest mdTemp = MessageDigest.getInstance("MD5");
            mdTemp.update(bytes);
            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (byte byte0 : md) {
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(str);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(HttpServletResponse response, File file, boolean deleteOnExit) {
        response.setContentType("application/octet-stream");
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            response.setHeader("Content-Disposition", "attachment; filename=" + file.getName());
            IOUtils.copy((InputStream)fis, (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                    if (deleteOnExit) {
                        file.deleteOnExit();
                    }
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static String getMd5(File file) {
        return FileUtil.getMd5(FileUtil.getByte(file));
    }

    static {
        String temp = System.getProperty("java.io.tmpdir");
        SYS_TEM_DIR = temp.endsWith("/") || temp.endsWith("\\") ? temp : temp + File.separator;
    }
}

