/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.utils;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.Week;
import java.util.Calendar;
import java.util.Date;

public class DateUtils
extends DateUtil {
    public static Date addDays(Date date, int days) {
        if (date == null) {
            return null;
        }
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        instance.add(5, days);
        return instance.getTime();
    }

    public static Date addHour(Date date, int hour) {
        if (date == null) {
            return null;
        }
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        instance.add(11, hour);
        return instance.getTime();
    }

    public static String getStartDate(Date date) {
        if (date == null) {
            return null;
        }
        return DateUtils.format((Date)date, (String)"yyyy-MM-dd") + " 00:00:00";
    }

    public static String getStartDate(String date) {
        if (date == null) {
            return null;
        }
        if (date.contains(":")) {
            return date.split(" ")[0] + " 00:00:00";
        }
        return date + " 00:00:00";
    }

    public static Date modifyHHmmss(Date date, int hour, int minute, int second) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        instance.set(11, hour);
        instance.set(12, minute);
        instance.set(13, second);
        instance.set(14, 0);
        return instance.getTime();
    }

    public static String getEndDate(Date date) {
        if (date == null) {
            return null;
        }
        return DateUtils.format((Date)date, (String)"yyyy-MM-dd") + " 23:59:59";
    }

    public static String getEndDate(String date) {
        if (date == null) {
            return null;
        }
        if (date.contains(":")) {
            return date.split(" ")[0] + " 23:59:59";
        }
        return date + " 23:59:59";
    }

    public static Date simpleParse(String date) {
        if (date == null) {
            return null;
        }
        if (!date.contains("-") && date.matches("\\d+")) {
            return new Date(Long.parseLong(date));
        }
        return date.contains(":") ? DateUtils.parse((CharSequence)date, (String)"yyyy-MM-dd HH:mm:ss") : DateUtils.parse((CharSequence)date, (String)"yyyy-MM-dd");
    }

    public static String dateStr(Date date, String defFormat, boolean defWeek) {
        if (date == null) {
            return null;
        }
        Date today = new Date();
        String dateStr = DateUtils.format((Date)date, (String)"yyyy-MM-dd");
        if (dateStr.equals(DateUtils.format((Date)today, (String)"yyyy-MM-dd"))) {
            return "\u4eca\u5929";
        }
        if (date.getTime() < today.getTime() && dateStr.equals(DateUtils.format((Date)DateUtils.addDays(today, -1), (String)"yyyy-MM-dd"))) {
            return "\u6628\u5929";
        }
        if (date.getTime() > today.getTime() && dateStr.equals(DateUtils.format((Date)DateUtils.addDays(today, 1), (String)"yyyy-MM-dd"))) {
            return "\u660e\u5929";
        }
        if (defWeek) {
            return DateUtils.format((Date)date, (String)defFormat) + " " + DateUtils.week(date);
        }
        return DateUtils.format((Date)date, (String)defFormat);
    }

    public static String getDurationStr(long duration) {
        if (duration < 3600000L) {
            return (int)(duration / 60000L) + "\u5206" + (int)(duration % 60000L / 1000L) + "\u79d2";
        }
        if (duration < 86400000L) {
            return (int)(duration / 3600000L) + "\u5c0f\u65f6" + (int)(duration % 3600000L / 60000L) + "\u5206";
        }
        return (int)(duration / 86400000L) + "\u5929" + (int)(duration % 86400000L / 3600000L) + "\u5c0f\u65f6" + (int)(duration % 3600000L / 60000L) + "\u5206";
    }

    public static String week(Date date) {
        Week week = DateUtils.dayOfWeekEnum((Date)date);
        switch (week) {
            case SUNDAY: {
                return "\u5468\u65e5";
            }
            case MONDAY: {
                return "\u5468\u4e00";
            }
            case TUESDAY: {
                return "\u5468\u4e8c";
            }
            case WEDNESDAY: {
                return "\u5468\u4e09";
            }
            case THURSDAY: {
                return "\u5468\u56db";
            }
            case FRIDAY: {
                return "\u5468\u4e94";
            }
            case SATURDAY: {
                return "\u5468\u516d";
            }
        }
        return null;
    }

    public static int days(String startDate, String endDate) {
        return DateUtils.days(DateUtils.simpleParse(startDate), DateUtils.simpleParse(endDate));
    }

    public static int days(Date startDate, Date endDate) {
        return (int)((endDate.getTime() - startDate.getTime() - 1L) / 86400000L) + 1;
    }
}

