/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.utils;

import cn.veasion.project.utils.StringComparator;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class CommonUtils {
    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(Object object) {
        boolean isEmpty = false;
        if (object == null) {
            isEmpty = true;
        } else if (object instanceof String) {
            isEmpty = CommonUtils.isEmpty((String)object);
        } else if (object instanceof Collection) {
            isEmpty = CommonUtils.isEmpty((Collection)object);
        } else if (object instanceof Map) {
            isEmpty = CommonUtils.isEmpty((Map)object);
        } else if (object instanceof Object[]) {
            isEmpty = CommonUtils.isEmpty((Object[])object);
        } else if (object.getClass().isArray()) {
            isEmpty = Array.getLength(object) == 0;
        }
        return isEmpty;
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CommonUtils.isEmpty(collection);
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !CommonUtils.isEmpty(map);
    }

    public static boolean isNotEmpty(String str) {
        return !CommonUtils.isEmpty(str);
    }

    public static boolean isNotEmpty(Object[] array) {
        return !CommonUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(Object object) {
        return !CommonUtils.isEmpty(object);
    }

    public static <T, U extends Comparable<? super U>> void sort(List<T> list, Function<? super T, ? extends U> field, boolean nullInLast) {
        list.sort((o1, o2) -> {
            Comparable value1 = (Comparable)field.apply(o1);
            Comparable value2 = (Comparable)field.apply(o2);
            if (value1 == null) {
                return nullInLast ? 1 : -1;
            }
            if (value2 == null) {
                return nullInLast ? -1 : 1;
            }
            if (value1 instanceof String || value2 instanceof String) {
                return new StringComparator().compare(value1.toString(), value2.toString());
            }
            return value1.compareTo(value2);
        });
    }

    public static <T> List<T> asList(T ... obj) {
        return new ArrayList<T>(Arrays.asList(obj));
    }

    public static MapBuilder<String, Object> buildMap() {
        return new MapBuilder<String, Object>();
    }

    public static <K, V> Map<K, V> singletonMap(K k1, V v1) {
        return Collections.singletonMap(k1, v1);
    }

    public static <K, V> Map<K, V> buildMap(K k1, V v1) {
        MapBuilder<K, V> builder = new MapBuilder<K, V>();
        return builder.put(k1, v1).build();
    }

    public static <K, V> Map<K, V> buildMap(K k1, V v1, K k2, V v2) {
        MapBuilder<K, V> builder = new MapBuilder<K, V>();
        return builder.put(k1, v1).put(k2, v2).build();
    }

    public static <K, V> Map<K, V> buildMap(K k1, V v1, K k2, V v2, K k3, V v3) {
        MapBuilder<K, V> builder = new MapBuilder<K, V>();
        return builder.put(k1, v1).put(k2, v2).put(k3, v3).build();
    }

    public static class MapBuilder<K, V> {
        private Map<K, V> map = new HashMap();

        public MapBuilder<K, V> put(K key, V value) {
            this.map.put(key, value);
            return this;
        }

        public MapBuilder<K, V> exec(Consumer<Map<K, V>> consumer) {
            consumer.accept(this.map);
            return this;
        }

        public Map<K, V> build() {
            return this.map;
        }
    }
}

