/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.session;

import cn.veasion.db.utils.ServiceLoaderUtils;
import cn.veasion.project.interceptor.CompanyInterceptor;
import cn.veasion.project.session.ISessionProvider;
import cn.veasion.project.session.ISessionUser;
import cn.veasion.project.session.SimpleSessionUser;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;

public class SessionHelper {
    public static final Long DEFAULT_COMPANY_ID;
    private static ISessionProvider sessionProvider;
    private static final ThreadLocal<ISessionUser> sessionUserHolder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R withUser(ISessionUser user, Supplier<R> supplier) {
        ISessionUser oldUser = sessionUserHolder.get();
        try {
            sessionUserHolder.set(user);
            R r = supplier.get();
            return r;
        }
        finally {
            if (oldUser != null) {
                sessionUserHolder.set(oldUser);
            } else {
                sessionUserHolder.remove();
            }
        }
    }

    public static void setUser(ISessionUser user) {
        sessionUserHolder.set(user);
    }

    public static void clear() {
        sessionUserHolder.remove();
    }

    public static SimpleSessionUser copySessionUser() {
        return new SimpleSessionUser(SessionHelper.getSessionUser());
    }

    public static ISessionUser getSessionUser() {
        ISessionUser sessionUser = sessionUserHolder.get();
        if (sessionUser == null && sessionProvider != null) {
            sessionUser = sessionProvider.getSessionUser();
        }
        return sessionUser;
    }

    public static String getUserId() {
        ISessionUser sessionUser = SessionHelper.getSessionUser();
        if (sessionUser == null) {
            return null;
        }
        return sessionUser.getUserId();
    }

    public static String getUserName() {
        ISessionUser sessionUser = SessionHelper.getSessionUser();
        if (sessionUser == null) {
            return null;
        }
        return sessionUser.getUserName();
    }

    public static Long getSessionCompanyId() {
        ISessionUser sessionUser = SessionHelper.getSessionUser();
        if (sessionUser == null) {
            return null;
        }
        return sessionUser.getCompanyId();
    }

    public static Long getCompanyId() {
        Long companyId = SessionHelper.getSessionCompanyId();
        if (companyId == null) {
            companyId = CompanyInterceptor.getThreadLocalCompanyId();
        }
        return companyId;
    }

    public static List<Long> getAuthCompanyIds() {
        ISessionUser sessionUser = SessionHelper.getSessionUser();
        if (sessionUser == null) {
            return null;
        }
        List<Long> authCompanyIds = sessionUser.getAuthCompanyIds();
        if (authCompanyIds == null && sessionUser.getCompanyId() != null) {
            return Arrays.asList(DEFAULT_COMPANY_ID, sessionUser.getCompanyId());
        }
        return authCompanyIds;
    }

    public static <T> T getOriginalUser() {
        ISessionUser sessionUser = SessionHelper.getSessionUser();
        if (sessionUser == null) {
            return null;
        }
        return (T)sessionUser.getOriginalUser();
    }

    static {
        sessionUserHolder = new ThreadLocal();
        sessionProvider = (ISessionProvider)ServiceLoaderUtils.loadOne(ISessionProvider.class);
        DEFAULT_COMPANY_ID = sessionProvider == null ? -1L : sessionProvider.defaultCompanyId();
    }
}

