/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.session;

import cn.veasion.project.session.SessionHelper;
import cn.veasion.project.session.SimpleSessionUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class DelegatingSessionExecutorService
implements ExecutorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatingSessionExecutorService.class);
    private ExecutorService delegate;
    private boolean useSecurityContext;

    public DelegatingSessionExecutorService(ExecutorService delegate) {
        this(delegate, false);
    }

    public DelegatingSessionExecutorService(ExecutorService delegate, boolean useSecurityContext) {
        this.delegate = Objects.requireNonNull(delegate);
        this.useSecurityContext = useSecurityContext;
    }

    public ExecutorService getDelegate() {
        return this.delegate;
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(this.wrap(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.delegate.submit(this.wrap(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.delegate.submit(this.wrap(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(this.createTasks(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(this.createTasks(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(this.createTasks(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(this.createTasks(tasks), timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(this.wrap(command));
    }

    private <T> Collection<Callable<T>> createTasks(Collection<? extends Callable<T>> tasks) {
        if (tasks == null) {
            return null;
        }
        ArrayList<Callable<T>> results = new ArrayList<Callable<T>>(tasks.size());
        for (Callable<T> callable : tasks) {
            results.add(this.wrap(callable));
        }
        return results;
    }

    protected Runnable wrap(Runnable runnable) {
        SecurityContext context;
        SimpleSessionUser sessionUser = SessionHelper.copySessionUser();
        if (this.useSecurityContext) {
            context = SecurityContextHolder.createEmptyContext();
            SecurityContext originalSecurityContext = SecurityContextHolder.getContext();
            if (originalSecurityContext != null) {
                context.setAuthentication(originalSecurityContext.getAuthentication());
            }
        } else {
            context = null;
        }
        return () -> {
            try {
                SessionHelper.setUser(sessionUser);
                if (this.useSecurityContext) {
                    SecurityContextHolder.setContext((SecurityContext)context);
                }
                runnable.run();
            }
            catch (Exception e) {
                LOGGER.error("\u5f02\u6b65\u6267\u884c\u5f02\u5e38", (Throwable)e);
                throw e;
            }
            finally {
                SessionHelper.clear();
                if (this.useSecurityContext) {
                    SecurityContextHolder.clearContext();
                }
            }
        };
    }

    protected <T> Callable<T> wrap(Callable<T> callable) {
        SecurityContext context;
        SimpleSessionUser sessionUser = SessionHelper.copySessionUser();
        if (this.useSecurityContext) {
            context = SecurityContextHolder.createEmptyContext();
            SecurityContext originalSecurityContext = SecurityContextHolder.getContext();
            if (originalSecurityContext != null) {
                context.setAuthentication(originalSecurityContext.getAuthentication());
            }
        } else {
            context = null;
        }
        return () -> {
            try {
                SessionHelper.setUser(sessionUser);
                if (this.useSecurityContext) {
                    SecurityContextHolder.setContext((SecurityContext)context);
                }
                Object v = callable.call();
                return v;
            }
            catch (Exception e) {
                LOGGER.error("\u5f02\u6b65\u6267\u884c\u5f02\u5e38", (Throwable)e);
                throw e;
            }
            finally {
                SessionHelper.clear();
                if (this.useSecurityContext) {
                    SecurityContextHolder.clearContext();
                }
            }
        };
    }
}

