/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.service;

import cn.veasion.project.service.CacheService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.stereotype.Service;

@Service
public class CacheServiceImpl
implements CacheService {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Resource
    private RedissonClient redissonClient;
    @Resource
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    public void set(String key, Object value, Long time, TimeUnit timeUnit) {
        if (time != null) {
            this.redisTemplate.opsForValue().set((Object)key, value, time.longValue(), timeUnit);
        } else {
            this.redisTemplate.opsForValue().set((Object)key, value);
        }
    }

    @Override
    public <R> R get(String key) {
        return this.tryGetValue(key);
    }

    @Override
    public void pushHash(String key, String hashKey, Object value) {
        this.redisTemplate.opsForHash().put((Object)key, (Object)hashKey, value);
    }

    @Override
    public <R> R getHash(String key, String hashKey) {
        return (R)this.redisTemplate.opsForHash().get((Object)key, (Object)hashKey);
    }

    @Override
    public <R> R loadCache(String key, Supplier<R> supplier, Long time, TimeUnit timeUnit, boolean refresh) {
        R value;
        R r = value = refresh ? null : (R)this.tryGetValue(key);
        if (value == null) {
            value = supplier.get();
            if (time != null) {
                this.redisTemplate.opsForValue().set((Object)key, value, time.longValue(), timeUnit);
            } else {
                this.redisTemplate.opsForValue().set((Object)key, value);
            }
        }
        return value;
    }

    @Override
    public <R> R loadHashCache(String mainKey, String key, Supplier<R> supplier, boolean refresh) {
        R value;
        R r = value = refresh ? null : (R)this.tryHashValue(mainKey, key);
        if (value == null) {
            value = supplier.get();
            try {
                this.redisTemplate.opsForHash().put((Object)mainKey, (Object)key, value);
            }
            catch (Exception e) {
                this.log.error("\u5199\u5165\u7f13\u5b58\u5931\u8d25\uff1a{} {}", new Object[]{mainKey, key, e});
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryLock(String key, Runnable runnable, int waitTime, int leaseTime, TimeUnit timeUnit) {
        boolean hasLock;
        RLock lock = null;
        try {
            lock = this.redissonClient.getLock(key);
            hasLock = lock.tryLock((long)waitTime, (long)leaseTime, timeUnit);
        }
        catch (Exception e) {
            this.log.error("\u83b7\u53d6\u9501\u5931\u8d25", (Throwable)e);
            hasLock = true;
        }
        if (hasLock) {
            try {
                runnable.run();
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R lock(String key, Supplier<R> supplier, int time, TimeUnit timeUnit, boolean tryLock) {
        RLock lock = null;
        try {
            if (tryLock) {
                try {
                    lock = this.redissonClient.getLock(key);
                    lock.lock((long)time, timeUnit);
                }
                catch (Exception e) {
                    this.log.error("\u83b7\u53d6\u9501\u5931\u8d25", (Throwable)e);
                }
            } else {
                lock = this.redissonClient.getLock(key);
                lock.lock((long)time, timeUnit);
            }
            R r = supplier.get();
            return r;
        }
        finally {
            if (lock != null && lock.isLocked()) {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R multiLock(String prefix, List<String> keys, boolean skipNull, Supplier<R> supplier, int time, TimeUnit timeUnit) {
        Stream<Object> stream = skipNull ? keys.stream().filter(Objects::nonNull) : keys.stream();
        List<RLock> locks = stream.distinct().map(key -> this.redissonClient.getLock(CacheService.buildKey(prefix, key))).collect(Collectors.toList());
        if (locks.isEmpty()) {
            return supplier.get();
        }
        RLock lock = this.redissonClient.getMultiLock(locks.toArray(new RLock[0]));
        try {
            lock.lock((long)time, timeUnit);
            R r = supplier.get();
            return r;
        }
        finally {
            try {
                lock.unlock();
            }
            catch (Exception e) {
                locks.stream().filter(RLock::isLocked).forEach(Lock::unlock);
            }
        }
    }

    private <R> R tryGetValue(String key) {
        try {
            return (R)this.redisTemplate.opsForValue().get((Object)key);
        }
        catch (Exception e) {
            this.log.error("\u52a0\u8f7d\u7f13\u5b58\u5931\u8d25\uff1akey = " + key, (Throwable)e);
            return null;
        }
    }

    private <R> R tryHashValue(String mainKey, String key) {
        try {
            return (R)this.redisTemplate.opsForHash().get((Object)mainKey, (Object)key);
        }
        catch (Exception e) {
            this.log.error("\u52a0\u8f7d\u7f13\u5b58\u5931\u8d25\uff1amainKey = {}, key = {}", new Object[]{mainKey, key, e});
            return null;
        }
    }

    @Override
    public Long getExpire(String key, TimeUnit timeUnit) {
        return this.redisTemplate.getExpire((Object)key, timeUnit);
    }

    @Override
    public boolean expire(String key, long time, TimeUnit timeUnit) {
        return Boolean.TRUE.equals(this.redisTemplate.expire((Object)key, time, timeUnit));
    }

    @Override
    public boolean expireAt(String key, Date date) {
        return Boolean.TRUE.equals(this.redisTemplate.expireAt((Object)key, date));
    }

    @Override
    public boolean hasKey(String key) {
        return Boolean.TRUE.equals(this.redisTemplate.hasKey((Object)key));
    }

    @Override
    public Long incr(String key, long l) {
        return this.redisTemplate.opsForValue().increment((Object)key, l);
    }

    @Override
    public Long incrHash(String mainKey, String key, long l) {
        return this.redisTemplate.opsForHash().increment((Object)mainKey, (Object)key, l);
    }

    @Override
    public void delete(String key) {
        this.redisTemplate.delete((Object)key);
    }

    @Override
    public void deleteHash(String mainKey, String key) {
        this.redisTemplate.opsForHash().delete((Object)mainKey, new Object[]{key});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> scanKeys(String pattern) {
        ScanOptions options = ScanOptions.scanOptions().match(pattern).build();
        RedisConnectionFactory factory = this.redisTemplate.getConnectionFactory();
        RedisConnection connection = Objects.requireNonNull(factory).getConnection();
        ArrayList<String> keys = new ArrayList<String>();
        try {
            Cursor cursor = connection.scan(options);
            while (cursor.hasNext()) {
                keys.add(new String((byte[])cursor.next()));
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)connection, (RedisConnectionFactory)factory);
        }
        return keys;
    }

    @Override
    public void scanDelete(String pattern) {
        List<String> keys = this.scanKeys(pattern);
        if (!keys.isEmpty()) {
            this.redisTemplate.delete(keys);
        }
    }

    @Override
    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }
}

