/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.service;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.data.redis.core.RedisTemplate;

public interface CacheService {
    public void set(String var1, Object var2, Long var3, TimeUnit var4);

    public <R> R get(String var1);

    public void pushHash(String var1, String var2, Object var3);

    public <R> R getHash(String var1, String var2);

    default public <R> R loadCache(String key, Supplier<R> supplier) {
        return this.loadCache(key, supplier, null, null);
    }

    default public <R> R loadCache(String key, Supplier<R> supplier, boolean refresh) {
        return this.loadCache(key, supplier, null, null, refresh);
    }

    default public <R> R loadCache(String key, Supplier<R> supplier, Long time, TimeUnit timeUnit) {
        return this.loadCache(key, supplier, time, timeUnit, false);
    }

    public <R> R loadCache(String var1, Supplier<R> var2, Long var3, TimeUnit var4, boolean var5);

    default public <R> R loadHashCache(String mainKey, String key, Supplier<R> supplier) {
        return this.loadHashCache(mainKey, key, supplier, false);
    }

    public <R> R loadHashCache(String var1, String var2, Supplier<R> var3, boolean var4);

    default public boolean tryLock(String key, Runnable runnable) {
        return this.tryLock(key, runnable, 0, 1, TimeUnit.MINUTES);
    }

    public boolean tryLock(String var1, Runnable var2, int var3, int var4, TimeUnit var5);

    default public <R> R lock(String key, Supplier<R> supplier) {
        return this.lock(key, supplier, 1, TimeUnit.MINUTES);
    }

    default public <R> R lock(String key, Supplier<R> supplier, int time, TimeUnit timeUnit) {
        return this.lock(key, supplier, time, timeUnit, true);
    }

    public <R> R lock(String var1, Supplier<R> var2, int var3, TimeUnit var4, boolean var5);

    default public <R> R multiLock(String prefix, List<String> keys, boolean skipNull, Supplier<R> supplier) {
        return this.multiLock(prefix, keys, skipNull, supplier, 1, TimeUnit.MINUTES);
    }

    public <R> R multiLock(String var1, List<String> var2, boolean var3, Supplier<R> var4, int var5, TimeUnit var6);

    public Long getExpire(String var1, TimeUnit var2);

    public boolean expire(String var1, long var2, TimeUnit var4);

    public boolean expireAt(String var1, Date var2);

    public boolean hasKey(String var1);

    public Long incr(String var1, long var2);

    public Long incrHash(String var1, String var2, long var3);

    public void delete(String var1);

    public void deleteHash(String var1, String var2);

    public List<String> scanKeys(String var1);

    public void scanDelete(String var1);

    public RedisTemplate<String, Object> getRedisTemplate();

    public static String buildKey(Object ... keys) {
        return Arrays.stream(keys).map(String::valueOf).collect(Collectors.joining("_"));
    }
}

