/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.service;

import cn.veasion.db.FilterException;
import cn.veasion.db.base.Page;
import cn.veasion.db.criteria.CommonQueryCriteria;
import cn.veasion.db.criteria.QueryCriteriaConvert;
import cn.veasion.db.jdbc.EntityDao;
import cn.veasion.db.query.AbstractQuery;
import cn.veasion.db.query.EntityQuery;
import cn.veasion.db.query.OrderParam;
import cn.veasion.db.query.SubQuery;
import cn.veasion.db.update.AbstractJoinUpdate;
import cn.veasion.db.update.AbstractUpdate;
import cn.veasion.db.update.BatchEntityInsert;
import cn.veasion.db.update.Delete;
import cn.veasion.db.update.EntityInsert;
import cn.veasion.project.model.ICreateUpdate;
import cn.veasion.project.service.BaseService;
import cn.veasion.project.service.InitEntity;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public abstract class BaseServiceImpl<VO, PO, ID>
extends InitEntity
implements BaseService<VO, PO, ID> {
    protected Class<VO> voClass;

    protected abstract EntityDao<PO, ID> getEntityDao();

    @Override
    public VO queryById(ID id) {
        return this.queryById(id, this.getVoClass());
    }

    @Override
    public List<VO> list(CommonQueryCriteria queryCriteria, Consumer<EntityQuery> consumer) {
        return this.queryList(queryCriteria, this.getVoClass(), consumer);
    }

    public <E> List<E> queryList(CommonQueryCriteria queryCriteria, Class<E> clazz, Consumer<EntityQuery> consumer) {
        List<E> list;
        QueryCriteriaConvert convert = new QueryCriteriaConvert((Object)queryCriteria, this.getEntityClass());
        this.handleQueryCriteria(convert, queryCriteria);
        EntityQuery entityQuery = convert.getEntityQuery();
        if (consumer != null) {
            consumer.accept(entityQuery);
        }
        if ((list = this.queryList((AbstractQuery<?>)entityQuery, clazz)) != null && !list.isEmpty()) {
            this.handleQueryCriteriaResult(convert, queryCriteria, list);
        }
        return list;
    }

    @Override
    public Page<VO> listPage(CommonQueryCriteria queryCriteria, Consumer<EntityQuery> consumer) {
        return this.queryPage(queryCriteria, this.getVoClass(), consumer);
    }

    public <E> Page<E> queryPage(CommonQueryCriteria queryCriteria, Class<E> clazz, Consumer<EntityQuery> consumer) {
        Page<E> page;
        List list;
        QueryCriteriaConvert convert = new QueryCriteriaConvert((Object)queryCriteria, this.getEntityClass());
        this.handleQueryCriteria(convert, queryCriteria);
        EntityQuery entityQuery = convert.getEntityQuery();
        if (entityQuery.getPageParam() == null) {
            entityQuery.page(1, 10);
        }
        if (consumer != null) {
            consumer.accept(entityQuery);
        }
        if ((list = (page = this.queryPage((AbstractQuery<?>)entityQuery, clazz)).getList()) != null && !list.isEmpty()) {
            this.handleQueryCriteriaResult(convert, queryCriteria, list);
        }
        return page;
    }

    protected void handleQueryCriteria(QueryCriteriaConvert convert, CommonQueryCriteria queryCriteria) {
        EntityQuery entityQuery = (EntityQuery)convert.getEntityQuery().selectAll();
        if (queryCriteria.getPage() != null && queryCriteria.getSize() != null) {
            entityQuery.page(queryCriteria.getPage().intValue(), queryCriteria.getSize().intValue());
        }
        if (queryCriteria.getOrders() != null) {
            for (OrderParam order : queryCriteria.getOrders()) {
                String field = order.getField();
                if (!QueryCriteriaConvert.FIELD_PATTERN.matcher(field).matches() || field.length() > 30) {
                    throw new FilterException("\u975e\u6cd5\u5b57\u6bb5\uff1a" + field);
                }
                entityQuery.order(order);
            }
        }
        this.handleQuery((AbstractQuery<?>)entityQuery);
        if (entityQuery.getOrders() == null && ICreateUpdate.class.isAssignableFrom(this.getEntityClass())) {
            entityQuery.desc("createTime");
        }
    }

    protected void handleQueryCriteriaResult(QueryCriteriaConvert convert, CommonQueryCriteria queryCriteria, List<?> list) {
        convert.handleResultLoadRelation(this.getEntityDao(), list);
    }

    public ID add(EntityInsert entityInsert) {
        Object entity = entityInsert.getEntity();
        this.initEntity(entity);
        return (ID)this.getEntityDao().add(entityInsert);
    }

    public ID[] batchAdd(BatchEntityInsert batchEntityInsert) {
        List entityList = batchEntityInsert.getEntityList();
        if (entityList != null) {
            for (Object entity : entityList) {
                this.initEntity(entity);
            }
        }
        return this.getEntityDao().batchAdd(batchEntityInsert);
    }

    public <E> E queryForType(AbstractQuery<?> abstractQuery, Class<E> aClass) {
        if (!(abstractQuery instanceof SubQuery)) {
            this.handleQuery(abstractQuery);
        }
        return (E)this.getEntityDao().queryForType(abstractQuery, aClass);
    }

    public Map<String, Object> queryForMap(AbstractQuery<?> abstractQuery, boolean b) {
        if (!(abstractQuery instanceof SubQuery)) {
            this.handleQuery(abstractQuery);
        }
        return this.getEntityDao().queryForMap(abstractQuery, b);
    }

    public List<Map<String, Object>> listForMap(AbstractQuery<?> abstractQuery, boolean b) {
        if (!(abstractQuery instanceof SubQuery)) {
            this.handleQuery(abstractQuery);
        }
        return this.getEntityDao().listForMap(abstractQuery, b);
    }

    public <E> List<E> queryList(AbstractQuery<?> abstractQuery, Class<E> aClass) {
        if (!(abstractQuery instanceof SubQuery)) {
            this.handleQuery(abstractQuery);
        }
        return this.getEntityDao().queryList(abstractQuery, aClass);
    }

    public <E> Page<E> queryPage(AbstractQuery<?> abstractQuery, Class<E> aClass) {
        if (!(abstractQuery instanceof SubQuery)) {
            this.handleQuery(abstractQuery);
        }
        return this.getEntityDao().queryPage(abstractQuery, aClass);
    }

    public int update(AbstractUpdate<?> abstractUpdate) {
        if (abstractUpdate instanceof AbstractJoinUpdate) {
            this.updateInitEntity(((AbstractJoinUpdate)abstractUpdate).getEntity());
        }
        return this.getEntityDao().update(abstractUpdate);
    }

    protected void handleQuery(AbstractQuery<?> abstractQuery) {
    }

    public int delete(Delete delete) {
        return this.getEntityDao().delete(delete);
    }

    public Class<PO> getEntityClass() {
        return this.getEntityDao().getEntityClass();
    }

    protected Class<VO> getVoClass() {
        ParameterizedType parameterizedType;
        Type rawType;
        if (this.voClass != null) {
            return this.voClass;
        }
        Type genericSuperclass = this.getClass().getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)genericSuperclass).getRawType()) instanceof Class && BaseServiceImpl.class.isAssignableFrom((Class)rawType)) {
            this.voClass = (Class)parameterizedType.getActualTypeArguments()[0];
            return this.voClass;
        }
        throw new RuntimeException("\u83b7\u53d6VO\u7c7b\u578b\u5931\u8d25\uff0c\u8bf7\u91cd\u5199 getVoClass() \u65b9\u6cd5");
    }
}

