/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.mongo;

import cn.hutool.core.collection.CollectionUtil;
import cn.veasion.db.base.Page;
import cn.veasion.db.criteria.CommonQueryCriteria;
import cn.veasion.db.query.OrderParam;
import cn.veasion.project.interceptor.CompanyInterceptor;
import cn.veasion.project.model.ICompanyId;
import cn.veasion.project.mongo.MQueryCriteriaConvert;
import cn.veasion.project.mongo.MongoBaseService;
import cn.veasion.project.service.InitEntity;
import com.mongodb.client.result.DeleteResult;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Resource;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.InvalidMongoDbApiUsageException;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public abstract class MongoBaseServiceImpl<M, Q extends CommonQueryCriteria>
extends InitEntity
implements MongoBaseService<M, Q> {
    @Resource
    protected MongoTemplate mongoTemplate;
    private Class<M> entityClass;

    @Override
    public M insert(M obj) {
        this.initEntity(obj);
        return (M)this.mongoTemplate.insert(obj);
    }

    @Override
    public List<M> insertAll(List<M> list) {
        for (M obj : list) {
            this.initEntity(obj);
        }
        Collection newList = this.mongoTemplate.insert(list, this.getEntityClass());
        if (newList instanceof List) {
            return (List)newList;
        }
        return new ArrayList(newList);
    }

    @Override
    public M saveOrUpdate(M obj) {
        this.initEntity(obj);
        this.updateInitEntity(obj);
        return (M)this.mongoTemplate.save(obj);
    }

    @Override
    public M getById(Object id) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is(id));
        this.handleCompanyInterceptor(query);
        return (M)this.mongoTemplate.findOne(query, this.getEntityClass());
    }

    @Override
    public <T> T findOne(Query query, Class<T> clazz) {
        this.handleCompanyInterceptor(query);
        return (T)this.mongoTemplate.findOne(query, clazz, this.mongoTemplate.getCollectionName(this.getEntityClass()));
    }

    @Override
    public <T> T findOne(Q criteria, Consumer<Query> consumer, Class<T> clazz) {
        Query query = this.buildQuery(criteria, false);
        if (consumer != null) {
            consumer.accept(query);
        }
        return (T)this.mongoTemplate.findOne(query, clazz, this.mongoTemplate.getCollectionName(this.getEntityClass()));
    }

    @Override
    public <T> List<T> list(Query query, Class<T> clazz) {
        this.handleCompanyInterceptor(query);
        return this.mongoTemplate.find(query, clazz, this.mongoTemplate.getCollectionName(this.getEntityClass()));
    }

    @Override
    public <T> Page<T> listPage(Q criteria, Consumer<Query> consumer, Class<T> clazz) {
        List list;
        long count;
        Query query = this.buildQuery(criteria, false);
        if (consumer != null) {
            consumer.accept(query);
        }
        if ((count = this.mongoTemplate.count(query, this.getEntityClass())) > 0L) {
            query.skip((long)criteria.getSize().intValue() * (long)(criteria.getPage() - 1)).limit(criteria.getSize().intValue());
            list = this.mongoTemplate.find(query, clazz, this.mongoTemplate.getCollectionName(this.getEntityClass()));
        } else {
            list = new ArrayList();
        }
        return new Page(criteria.getPage().intValue(), criteria.getSize().intValue(), (long)((int)count), list);
    }

    @Override
    public Page<M> listPage(Q criteria) {
        return this.listPage(criteria, null, this.getEntityClass());
    }

    @Override
    public <T> List<T> list(Q criteria, Consumer<Query> consumer, Class<T> clazz) {
        if (criteria.getPage() == null) {
            criteria.setPage(Integer.valueOf(1));
        }
        if (criteria.getSize() == null) {
            criteria.setSize(Integer.valueOf(10000));
        }
        Query query = this.buildQuery(criteria, true);
        if (consumer != null) {
            consumer.accept(query);
        }
        return this.mongoTemplate.find(query, clazz, this.mongoTemplate.getCollectionName(this.getEntityClass()));
    }

    @Override
    public List<M> list(Q criteria) {
        return this.list(criteria, null, this.getEntityClass());
    }

    @Override
    public int deleteById(Object id) {
        if (id == null) {
            return 0;
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is(id));
        this.handleCompanyInterceptor(query);
        DeleteResult result = this.mongoTemplate.remove(query, this.getEntityClass());
        return (int)result.getDeletedCount();
    }

    @Override
    public int delete(Q criteria) {
        Query query = this.buildQuery(criteria, false);
        this.handleCompanyInterceptor(query);
        DeleteResult result = this.mongoTemplate.remove(query, this.getEntityClass());
        return (int)result.getDeletedCount();
    }

    @Override
    public long count(Q criteria, Consumer<Query> consumer) {
        Query query = this.buildQuery(criteria, false);
        if (consumer != null) {
            consumer.accept(query);
        }
        return this.mongoTemplate.count(query, this.getEntityClass());
    }

    protected Query buildQuery(Q criteria, boolean page) {
        return this.buildQuery(null, criteria, page);
    }

    protected Query buildQuery(Query query, Q criteria, boolean page) {
        if (query == null) {
            query = new Query();
        }
        if (page && criteria.getPage() != null && criteria.getSize() != null) {
            query.skip((long)(criteria.getSize() * (criteria.getPage() - 1))).limit(criteria.getSize().intValue());
        }
        MQueryCriteriaConvert.handleFilters(query, criteria);
        if (CollectionUtil.isNotEmpty((Collection)criteria.getOrders())) {
            for (OrderParam order : criteria.getOrders()) {
                if (order.isDesc()) {
                    query.with(Sort.by((String[])new String[]{order.getField()}).descending());
                    continue;
                }
                query.with(Sort.by((String[])new String[]{order.getField()}).ascending());
            }
        }
        this.handleCompanyInterceptor(query);
        return query;
    }

    protected void handleCompanyInterceptor(Query query) {
        if (this.companyInterceptor()) {
            try {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"companyId").in(CompanyInterceptor.companyIds()));
            }
            catch (InvalidMongoDbApiUsageException invalidMongoDbApiUsageException) {
                // empty catch block
            }
        }
    }

    protected boolean companyInterceptor() {
        if (CompanyInterceptor.isSkip()) {
            return false;
        }
        return ICompanyId.class.isAssignableFrom(this.getEntityClass());
    }

    protected String getCollectionName() {
        Document annotation = this.getEntityClass().getAnnotation(Document.class);
        if (annotation != null) {
            return annotation.value();
        }
        return null;
    }

    protected Class<M> getEntityClass() {
        ParameterizedType parameterizedType;
        Type rawType;
        if (this.entityClass != null) {
            return this.entityClass;
        }
        Type genericSuperclass = this.getClass().getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)genericSuperclass).getRawType()) instanceof Class && MongoBaseService.class.isAssignableFrom((Class)rawType)) {
            this.entityClass = (Class)parameterizedType.getActualTypeArguments()[0];
            return this.entityClass;
        }
        throw new RuntimeException("\u83b7\u53d6\u5b9e\u4f53\u7c7b\u578b\u5931\u8d25\uff0c\u8bf7\u91cd\u5199 getEntityClass() \u65b9\u6cd5");
    }
}

