/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.mongo;

import cn.veasion.db.FilterException;
import cn.veasion.db.base.Operator;
import cn.veasion.db.criteria.AutoCriteria;
import cn.veasion.db.criteria.CommonQueryCriteria;
import cn.veasion.db.criteria.QueryCriteria;
import cn.veasion.db.utils.FieldUtils;
import cn.veasion.project.utils.DateUtils;
import cn.veasion.project.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.ProjectionOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class MQueryCriteriaConvert {
    public static final Pattern FIELD_PATTERN = Pattern.compile("[_0-9a-zA-Z.]+");

    public static Map<String, Criteria> handleFilters(Query query, CommonQueryCriteria criteria) {
        Objects.requireNonNull(query, "query is null");
        HashMap<String, Criteria> map = new HashMap<String, Criteria>();
        if (criteria == null) {
            return map;
        }
        Map fields = FieldUtils.fields(criteria.getClass());
        for (Field field : fields.values()) {
            Object value;
            QueryCriteria queryCriteria = field.getAnnotation(QueryCriteria.class);
            AutoCriteria autoCriteria = field.getAnnotation(AutoCriteria.class);
            if (queryCriteria == null && autoCriteria == null || (value = FieldUtils.getValue((Object)criteria, (String)field.getName(), (boolean)true)) == null) continue;
            if (queryCriteria != null) {
                MQueryCriteriaConvert.handleQueryCriteria(map, query, field, queryCriteria, value);
                continue;
            }
            if (value instanceof Map) {
                MQueryCriteriaConvert.handleAutoCriteria(map, query, autoCriteria, (Map)value);
                continue;
            }
            MQueryCriteriaConvert.handleAutoCriteria(map, query, autoCriteria, Collections.singletonMap(field.getName(), value));
        }
        return map;
    }

    public static Criteria handleFilters(Criteria criteria, Map<String, Object> filters) {
        return MQueryCriteriaConvert.handleFilters(criteria, filters, true, new String[0]);
    }

    public static Criteria handleFilters(Criteria criteria, Map<String, Object> filters, boolean skipEmpty, String ... keys) {
        HashSet<String> filterKeys = keys != null && keys.length > 0 ? new HashSet<String>(Arrays.asList(keys)) : null;
        for (Map.Entry<String, Object> entry : filters.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null || skipEmpty && MQueryCriteriaConvert.isEmpty(value)) continue;
            boolean xdEQ = key.startsWith("-");
            if (xdEQ) {
                key = key.substring(1);
            }
            if (!FIELD_PATTERN.matcher(key).matches() || key.length() > 30) {
                throw new FilterException("\u975e\u6cd5\u5b57\u6bb5\uff1a" + key);
            }
            KVOperator kvOperator = MQueryCriteriaConvert.buildKVOperator(key, value, xdEQ);
            if (filterKeys != null && !filterKeys.contains(kvOperator.field)) continue;
            criteria = MQueryCriteriaConvert.addFilter(criteria, kvOperator);
        }
        return criteria;
    }

    public static ProjectionOperation project(Class<?> clazz, String objectField) {
        return MQueryCriteriaConvert.project(clazz, objectField, null);
    }

    public static ProjectionOperation project(Class<?> clazz, String objectField, Map<String, String> asMap) {
        ProjectionOperation operation = Aggregation.project((String[])new String[0]);
        Map fieldMap = FieldUtils.fields(clazz);
        for (Map.Entry entry : fieldMap.entrySet()) {
            if (((Field)entry.getValue()).getAnnotation(Transient.class) != null) continue;
            String name = (String)entry.getKey();
            if ("id".equals(name) || ((Field)entry.getValue()).getAnnotation(Id.class) != null) {
                name = "_id";
            }
            String asName = name;
            if (asMap != null && asMap.containsKey(name)) {
                asName = asMap.get(name);
            }
            if (StringUtils.isNotEmpty((CharSequence)objectField)) {
                operation = operation.and(objectField + "." + name).as(asName);
                continue;
            }
            operation = operation.and(name).as(asName);
        }
        return operation;
    }

    private static void handleAutoCriteria(Map<String, Criteria> map, Query query, AutoCriteria annotation, Map<String, Object> filters) {
        for (Map.Entry<String, Object> entry : filters.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null || annotation.skipEmpty() && MQueryCriteriaConvert.isEmpty(value)) continue;
            boolean xdEQ = key.startsWith("-");
            if (xdEQ) {
                key = key.substring(1);
            }
            if (!FIELD_PATTERN.matcher(key).matches() || key.length() > 30) {
                throw new FilterException("\u975e\u6cd5\u5b57\u6bb5\uff1a" + key);
            }
            MQueryCriteriaConvert.addFilter(map, query, MQueryCriteriaConvert.buildKVOperator(key, value, xdEQ));
        }
    }

    private static KVOperator buildKVOperator(String key, Object value, boolean xdEQ) {
        Operator operator = Operator.EQ;
        if (value instanceof Collection || value instanceof Object[]) {
            if (!xdEQ && key.startsWith("neq_")) {
                key = key.substring(4);
                operator = Operator.NOT_IN;
            } else {
                operator = Operator.IN;
            }
        } else if (!xdEQ) {
            if (key.startsWith("neq_")) {
                key = key.substring(4);
                operator = Operator.NEQ;
            } else if (key.startsWith("gt_")) {
                key = key.substring(3);
                operator = Operator.GT;
            } else if (key.startsWith("gte_")) {
                key = key.substring(4);
                operator = Operator.GTE;
            } else if (key.startsWith("start_")) {
                key = key.substring(6);
                operator = Operator.GTE;
            } else if (key.startsWith("lt_")) {
                key = key.substring(3);
                operator = Operator.LT;
            } else if (key.startsWith("lte_") || key.startsWith("end_")) {
                key = key.substring(4);
                operator = Operator.LTE;
            } else if (value instanceof String && (String.valueOf(value).startsWith("%") || String.valueOf(value).endsWith("%"))) {
                operator = Operator.LIKE;
            }
        }
        if (value instanceof String) {
            String v = (String)value;
            if (v.length() == 19 && v.contains(":")) {
                try {
                    value = DateUtils.parse((CharSequence)value.toString(), (String)"yyyy-MM-dd HH:mm:ss");
                }
                catch (Exception exception) {}
            } else if (v.length() == 10 && v.contains("-")) {
                try {
                    value = DateUtils.parse((CharSequence)value.toString(), (String)"yyyy-MM-dd");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return new KVOperator(key, operator, value);
    }

    private static void handleQueryCriteria(Map<String, Criteria> map, Query query, Field field, QueryCriteria annotation, Object value) {
        if (annotation.skipEmpty() && MQueryCriteriaConvert.isEmpty(value)) {
            return;
        }
        String fieldName = "".equals(annotation.field()) ? field.getName() : annotation.field();
        Operator operator = annotation.value();
        String[] orFields = annotation.orFields();
        if (orFields.length > 0) {
            query.addCriteria((CriteriaDefinition)new Criteria().orOperator((Collection)Arrays.stream(orFields).map(key -> MQueryCriteriaConvert.appendCriteria(Criteria.where((String)key), operator, value)).collect(Collectors.toList())));
        } else {
            MQueryCriteriaConvert.addFilter(map, query, new KVOperator(fieldName, operator, value));
        }
    }

    private static void addFilter(Map<String, Criteria> map, Query query, KVOperator kvOperator) {
        Criteria criteria = map.get(kvOperator.field);
        if (criteria != null) {
            MQueryCriteriaConvert.appendCriteria(criteria, kvOperator.operator, kvOperator.value);
        } else {
            criteria = Criteria.where((String)kvOperator.field);
            MQueryCriteriaConvert.appendCriteria(criteria, kvOperator.operator, kvOperator.value);
            query.addCriteria((CriteriaDefinition)criteria);
            map.put(kvOperator.field, criteria);
        }
    }

    private static Criteria addFilter(Criteria criteria, KVOperator kvOperator) {
        String field = "id".equals(kvOperator.field) ? "_id" : kvOperator.field;
        criteria = criteria == null ? new Criteria(field) : criteria.and(field);
        return MQueryCriteriaConvert.appendCriteria(criteria, kvOperator.operator, kvOperator.value);
    }

    public static Criteria appendCriteria(Criteria criteria, Operator operator, Object value) {
        if (Operator.EQ.equals((Object)operator)) {
            return criteria.is(value);
        }
        if (Operator.NEQ.equals((Object)operator)) {
            return criteria.ne(value);
        }
        if (Operator.GT.equals((Object)operator)) {
            return criteria.gt(value);
        }
        if (Operator.GTE.equals((Object)operator)) {
            return criteria.gte(value);
        }
        if (Operator.LT.equals((Object)operator)) {
            return criteria.lt(value);
        }
        if (Operator.LTE.equals((Object)operator)) {
            return criteria.lte(value);
        }
        if (Operator.IN.equals((Object)operator)) {
            if (value instanceof Collection) {
                return criteria.in((Collection)value);
            }
            if (value instanceof Object[]) {
                return criteria.in((Object[])value);
            }
            throw new FilterException("Operator.IN \u7c7b\u578b\u5fc5\u987b\u662f\u96c6\u5408\u6216\u8005\u6570\u7ec4");
        }
        if (Operator.NOT_IN.equals((Object)operator)) {
            if (value instanceof Collection) {
                return criteria.nin((Collection)value);
            }
            if (value instanceof Object[]) {
                return criteria.nin((Object[])value);
            }
            throw new FilterException("Operator.IN \u7c7b\u578b\u5fc5\u987b\u662f\u96c6\u5408\u6216\u8005\u6570\u7ec4");
        }
        if (Operator.LIKE.equals((Object)operator)) {
            String str = String.valueOf(value);
            if (value instanceof String) {
                if (str.startsWith("%") && str.endsWith("%")) {
                    str = str.substring(1, str.length() - 1);
                } else if (str.startsWith("%")) {
                    str = "^" + str.substring(1);
                } else if (str.endsWith("%")) {
                    str = str.substring(0, str.length() - 1) + "$";
                }
            }
            return criteria.regex(str);
        }
        if (Operator.BETWEEN.equals((Object)operator)) {
            if (value instanceof Collection) {
                Iterator iterator = ((Collection)value).iterator();
                return criteria.gte(iterator.next()).lte(iterator.next());
            }
            if (value instanceof Object[]) {
                Object[] objects = (Object[])value;
                return criteria.gte(objects[0]).lte(objects[1]);
            }
            throw new FilterException("Operator.BETWEEN \u7c7b\u578b\u5fc5\u987b\u662f\u96c6\u5408\u6216\u8005\u6570\u7ec4");
        }
        if (Operator.NULL.equals((Object)operator) && !Boolean.FALSE.equals(value)) {
            return criteria.is(null);
        }
        if (Operator.NOT_NULL.equals((Object)operator) && !Boolean.FALSE.equals(value)) {
            return criteria.ne(null);
        }
        throw new FilterException("\u4e0d\u652f\u6301 Operator." + operator.name());
    }

    private static boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return "".equals(value);
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty();
        }
        if (value instanceof Object[]) {
            return ((Object[])value).length == 0;
        }
        if (value instanceof Map) {
            return ((Map)value).isEmpty();
        }
        return false;
    }

    static class KVOperator {
        public String field;
        public Operator operator;
        public Object value;

        public KVOperator(String field, Operator operator, Object value) {
            this.field = field;
            this.operator = operator;
            this.value = value;
        }
    }
}

