/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.model;

import cn.veasion.project.model.JsonTypeConvert;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;

public abstract class JsonArrayTypeConvert<T>
extends JsonTypeConvert
implements List<T>,
Cloneable,
RandomAccess,
Serializable {
    private final List<T> list;
    private Class<T> elementClass;

    public JsonArrayTypeConvert() {
        this.list = new ArrayList<T>();
    }

    public JsonArrayTypeConvert(List<Object> list) {
        if (list == null) {
            throw new IllegalArgumentException("list is null.");
        }
        this.list = new ArrayList<T>(list.size());
        ParserConfig config = ParserConfig.getGlobalInstance();
        for (Object item : list) {
            Object classItem = TypeUtils.cast((Object)item, this.getElementClass(), (ParserConfig)config);
            this.list.add(classItem);
        }
    }

    public JsonArrayTypeConvert(int initialCapacity) {
        this.list = new ArrayList<T>(initialCapacity);
    }

    public Class<T> getElementClass() {
        ParameterizedType parameterizedType;
        Type rawType;
        if (this.elementClass != null) {
            return this.elementClass;
        }
        Type genericSuperclass = this.getClass().getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)genericSuperclass).getRawType()) instanceof Class && JsonArrayTypeConvert.class.isAssignableFrom((Class)rawType)) {
            this.elementClass = (Class)parameterizedType.getActualTypeArguments()[0];
            return this.elementClass;
        }
        throw new RuntimeException("\u83b7\u53d6\u7c7b\u578b\u5931\u8d25\uff0c\u8bf7\u91cd\u5199 getElementClass() \u65b9\u6cd5");
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(T object) {
        return this.list.add(object);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.list.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public T get(int index) {
        return this.list.get(index);
    }

    @Override
    public T set(int index, T element) {
        return this.list.set(index, element);
    }

    @Override
    public void add(int index, T element) {
        this.list.add(index, element);
    }

    @Override
    public T remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }
}

