/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.interceptor;

import cn.veasion.db.utils.TypeConvert;
import cn.veasion.db.utils.TypeUtils;
import cn.veasion.project.model.IEnum;
import cn.veasion.project.model.JsonTypeConvert;
import cn.veasion.project.utils.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ExtTypeConvert
implements TypeConvert {
    private static final Map<Class<?>, Map<Object, IEnum<?>>> ENUM_VALUE_CACHE = new ConcurrentHashMap();

    public <T> T convert(Object object, Class<T> clazz) {
        if (clazz.isEnum() && IEnum.class.isAssignableFrom(clazz)) {
            return this.valueToEnum(object, clazz);
        }
        if (object instanceof String && StringUtils.isNotEmpty((CharSequence)((String)object))) {
            String str = object.toString();
            if (JSON.class.isAssignableFrom(clazz)) {
                return (T)(JSONArray.class.equals(clazz) ? JSON.parseArray((String)str) : JSON.parseObject((String)str));
            }
            if (JsonTypeConvert.class.isAssignableFrom(clazz)) {
                return (T)JSON.parseObject((String)str, clazz);
            }
        }
        return null;
    }

    public Object convertValue(Object value) {
        if (value instanceof JSON || value instanceof JsonTypeConvert) {
            return value.toString();
        }
        if (value instanceof IEnum) {
            return ((IEnum)value).getValue();
        }
        return value;
    }

    public boolean isSimpleClass(Class<?> clazz) {
        return IEnum.class.isAssignableFrom(clazz);
    }

    private <T> T valueToEnum(Object object, Class<T> clazz) {
        Class<?> valueClass;
        IEnum<?> value;
        Map<Object, IEnum<?>> enumMap = ENUM_VALUE_CACHE.get(clazz);
        if (enumMap == null) {
            try {
                Method valuesMethod = clazz.getDeclaredMethod("values", new Class[0]);
                valuesMethod.setAccessible(true);
                Object values = valuesMethod.invoke(clazz, new Object[0]);
                enumMap = new HashMap();
                int length = Array.getLength(values);
                for (int i = 0; i < length; ++i) {
                    IEnum iEnum = (IEnum)Array.get(values, i);
                    if (iEnum.getValue() == null) continue;
                    enumMap.put(iEnum.getValue(), iEnum);
                }
                ENUM_VALUE_CACHE.put(clazz, enumMap);
            }
            catch (Exception e) {
                return null;
            }
        }
        if ((value = enumMap.get(object)) != null) {
            return (T)value;
        }
        if (enumMap.size() > 0 && (valueClass = enumMap.keySet().iterator().next().getClass()) != object.getClass()) {
            return (T)enumMap.get(TypeUtils.convert((Object)object, valueClass));
        }
        return null;
    }
}

