/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.interceptor;

import cn.veasion.db.AbstractFilter;
import cn.veasion.db.base.Filter;
import cn.veasion.db.interceptor.AbstractInterceptor;
import cn.veasion.db.update.Delete;
import cn.veasion.project.model.ICompanyId;
import cn.veasion.project.session.SessionHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class CompanyInterceptor
extends AbstractInterceptor {
    private static final String COMPANY_ID = "companyId";
    private static ThreadLocal<Boolean> skipThreadLocal = new ThreadLocal();
    private static ThreadLocal<Long> companyThreadLocal = new ThreadLocal();

    public CompanyInterceptor() {
        super(true, true, true, true, true);
    }

    public static boolean isSkip() {
        return Boolean.TRUE.equals(skipThreadLocal.get());
    }

    public static void skip(boolean skip) {
        skipThreadLocal.set(skip);
    }

    public static void clearSkip() {
        skipThreadLocal.remove();
    }

    public static <R> R withSkip(Supplier<R> supplier) {
        Boolean flag = skipThreadLocal.get();
        try {
            skipThreadLocal.set(true);
            R r = supplier.get();
            return r;
        }
        finally {
            if (flag != null) {
                skipThreadLocal.set(flag);
            } else {
                skipThreadLocal.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R withCompanyId(Long companyId, Supplier<R> supplier) {
        Long oldCompanyId = companyThreadLocal.get();
        try {
            companyThreadLocal.set(companyId);
            R r = supplier.get();
            return r;
        }
        finally {
            if (oldCompanyId != null) {
                companyThreadLocal.set(oldCompanyId);
            } else {
                companyThreadLocal.remove();
            }
        }
    }

    public static Long setCompanyId(Long companyId) {
        Long oldCompanyId = companyThreadLocal.get();
        companyThreadLocal.set(companyId);
        return oldCompanyId;
    }

    public static void clearCompanyId() {
        companyThreadLocal.remove();
    }

    protected boolean skip() {
        return Boolean.TRUE.equals(skipThreadLocal.get());
    }

    protected boolean containSkipClass(Class<?> clazz) {
        if (!ICompanyId.class.isAssignableFrom(clazz)) {
            return true;
        }
        return super.containSkipClass(clazz);
    }

    protected void handleDelete(Delete delete) {
        if (!delete.hasFilter(COMPANY_ID)) {
            delete.in(COMPANY_ID, CompanyInterceptor.companyIds());
        }
    }

    protected void handleOnFilter(Object joinParam, Supplier<List<Filter>> onFilters, Consumer<Filter> onMethod, String tableAs) {
        onMethod.accept(Filter.AND);
        onMethod.accept(Filter.in((String)COMPANY_ID, CompanyInterceptor.companyIds()).fieldAs(tableAs));
    }

    protected void handleFilter(AbstractFilter<?> abstractFilter) {
        if (!abstractFilter.hasFilter(COMPANY_ID)) {
            abstractFilter.in(COMPANY_ID, CompanyInterceptor.companyIds());
        }
    }

    protected void handleInsert(Class<?> entityClass, List<?> entityList, List<Map<String, Object>> fieldValueMapList) {
        if (entityList == null) {
            return;
        }
        Long companyId = companyThreadLocal.get();
        if (companyId == null) {
            companyId = SessionHelper.getCompanyId();
        }
        for (Object entity : entityList) {
            ICompanyId company;
            if (!(entity instanceof ICompanyId) || (company = (ICompanyId)entity).getCompanyId() != null) continue;
            company.setCompanyId(companyId);
        }
    }

    public static List<Long> companyIds() {
        Long companyId = companyThreadLocal.get();
        if (companyId != null) {
            return Arrays.asList(SessionHelper.DEFAULT_COMPANY_ID, companyId);
        }
        return SessionHelper.getAuthCompanyIds();
    }

    public static Long getThreadLocalCompanyId() {
        return companyThreadLocal.get();
    }
}

