/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.excel;

import cn.veasion.project.eval.EvalAnalysisUtils;
import cn.veasion.project.excel.ExcelExportUtils;
import cn.veasion.project.excel.MikuMikuExcel;
import cn.veasion.project.excel.MikuMikuExcelCell;
import cn.veasion.project.excel.MikuMikuExcelLayout;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import org.apache.poi.ss.usermodel.CellStyle;

public class MikuMikuExcelTable
extends MikuMikuExcel {
    private MikuMikuExcelTable() {
    }

    public static MikuMikuExcel of(LinkedHashMap<String, String> fieldNames, List<?> list) {
        return MikuMikuExcelTable.of(fieldNames, list, null, null);
    }

    public static MikuMikuExcel of(LinkedHashMap<String, String> fieldNames, List<?> list, Callback cellCallback, CellStyle headerStyle) {
        return MikuMikuExcelTable.of(fieldNames, list, cellCallback, 1, headerStyle);
    }

    public static MikuMikuExcel of(LinkedHashMap<String, String> fieldNames, List<?> list, Callback cellCallback, int headerRowNum, CellStyle headerStyle) {
        ArrayList<MikuMikuExcel> lines = new ArrayList<MikuMikuExcel>(list.size() + 1);
        lines.add(MikuMikuExcelLayout.cols(fieldNames.values(), v -> MikuMikuExcelCell.fixedRows(headerRowNum, v)).setCellStyle(headerStyle));
        for (int i = 0; i < list.size(); ++i) {
            int lineNumber = i + 1;
            Object data = list.get(i);
            if (data == null) {
                lines.add(MikuMikuExcelLayout.cols(fieldNames.keySet(), field -> MikuMikuExcelCell.fixed(null)));
                continue;
            }
            lines.add(MikuMikuExcelLayout.cols(fieldNames.keySet(), field -> {
                Object value;
                Object object = value = "lineNumber".equals(field) ? ExcelExportUtils.readField(data, field, lineNumber) : ExcelExportUtils.readField(data, field);
                if (cellCallback != null) {
                    return MikuMikuExcelCell.fixedByFunction(cell -> cellCallback.callback((String)field, value, (MikuMikuExcelCell)cell));
                }
                return MikuMikuExcelCell.fixed(value);
            }));
        }
        return MikuMikuExcelLayout.rows(lines, Function.identity());
    }

    public static MikuMikuExcel ofEval(Object object, String eval, LinkedHashMap<String, String> fieldNames) {
        return MikuMikuExcelTable.ofEval(object, eval, fieldNames, null, null);
    }

    public static MikuMikuExcel ofEval(Object object, String eval, LinkedHashMap<String, String> fieldNames, Callback cellCallback, CellStyle headerStyle) {
        return MikuMikuExcelTable.ofEval(object, eval, fieldNames, cellCallback, 1, headerStyle);
    }

    public static MikuMikuExcel ofEval(Object object, String eval, LinkedHashMap<String, String> fieldNames, Callback cellCallback, int headerRowNum, CellStyle headerStyle) {
        return MikuMikuExcelTable.of(fieldNames, (List)EvalAnalysisUtils.eval(eval, object), cellCallback, headerRowNum, headerStyle);
    }

    public static MikuMikuExcel empty(int rows, int cols) {
        return MikuMikuExcelCell.fixed(rows, cols, null);
    }

    @FunctionalInterface
    public static interface Callback {
        public Object callback(String var1, Object var2, MikuMikuExcelCell var3);
    }
}

