/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.excel;

import cn.veasion.project.eval.EvalAnalysisUtils;
import cn.veasion.project.excel.MikuMikuExcel;
import cn.veasion.project.excel.MikuMikuExcelCell;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MikuMikuExcelLayout
extends MikuMikuExcel {
    List<MikuMikuExcel> rows;
    List<MikuMikuExcel> cols;

    private MikuMikuExcelLayout(List<MikuMikuExcel> rows, List<MikuMikuExcel> cols) {
        this.rows = rows;
        this.cols = cols;
        if (rows != null) {
            List allRowCols = rows.stream().map(MikuMikuExcel::getColNum).filter(Objects::nonNull).sorted().collect(Collectors.toList());
            if (!allRowCols.isEmpty()) {
                this.colNum = allRowCols.stream().max(Integer::compareTo).orElse(0);
                rows.forEach(mme -> mme.solve(null, this.colNum));
            }
            if (rows.stream().allMatch(mme -> mme.getRowNum() != null)) {
                this.rowNum = rows.stream().mapToInt(MikuMikuExcel::getRowNum).sum();
            }
        }
        if (cols != null) {
            List allColRows = cols.stream().map(MikuMikuExcel::getRowNum).filter(Objects::nonNull).sorted().collect(Collectors.toList());
            if (!allColRows.isEmpty()) {
                this.rowNum = allColRows.stream().max(Integer::compareTo).orElse(0);
                cols.forEach(mme -> mme.solve(this.rowNum, null));
            }
            if (cols.stream().allMatch(mme -> mme.getColNum() != null)) {
                this.colNum = cols.stream().mapToInt(MikuMikuExcel::getColNum).sum();
            }
        }
    }

    @Override
    protected void travel(Consumer<MikuMikuExcelCell> consumer) {
        if (this.rows != null) {
            this.rows.forEach(o -> {
                if (o.getCellStyle() == null) {
                    o.setCellStyle(this.cellStyle);
                }
                o.travel(consumer);
            });
        }
        if (this.cols != null) {
            this.cols.forEach(o -> {
                if (o.getCellStyle() == null) {
                    o.setCellStyle(this.cellStyle);
                }
                o.travel(consumer);
            });
        }
    }

    @Override
    protected void solve(Integer rowNum, Integer colNum) {
        int i;
        if (colNum != null) {
            List unknownCols;
            this.colNum = colNum;
            if (this.rows != null) {
                this.rows.forEach(mme -> mme.solve(rowNum, colNum));
            }
            if (this.cols != null && !(unknownCols = this.cols.stream().filter(mme -> mme.colNum == null).collect(Collectors.toList())).isEmpty()) {
                int realColNum = colNum - this.cols.stream().map(MikuMikuExcel::getColNum).filter(Objects::nonNull).mapToInt(Integer::intValue).sum();
                if (realColNum < 1) {
                    logger.info("\u5df2\u77e5\u5217\u5c0f\u4e8e1\u65e0\u6cd5\u81ea\u52a8\u8ba1\u7b97\u6269\u5217");
                }
                for (i = 0; i < unknownCols.size(); ++i) {
                    if (i < unknownCols.size() - 1) {
                        ((MikuMikuExcel)unknownCols.get(i)).solve(rowNum, realColNum / unknownCols.size());
                        continue;
                    }
                    ((MikuMikuExcel)unknownCols.get(i)).solve(rowNum, realColNum / unknownCols.size() + realColNum % unknownCols.size());
                }
            }
        }
        if (rowNum != null) {
            List unknownRows;
            this.rowNum = rowNum;
            if (this.cols != null) {
                this.cols.forEach(mme -> mme.solve(rowNum, colNum));
            }
            if (this.rows != null && !(unknownRows = this.rows.stream().filter(mme -> mme.rowNum == null).collect(Collectors.toList())).isEmpty()) {
                int realRowNum = rowNum - this.rows.stream().map(MikuMikuExcel::getRowNum).filter(Objects::nonNull).mapToInt(Integer::intValue).sum();
                if (realRowNum < 1) {
                    logger.info("\u5df2\u77e5\u884c\u5c0f\u4e8e1\u65e0\u6cd5\u81ea\u52a8\u8ba1\u7b97\u6269\u884c");
                }
                for (i = 0; i < unknownRows.size(); ++i) {
                    if (i < unknownRows.size() - 1) {
                        ((MikuMikuExcel)unknownRows.get(i)).solve(realRowNum / unknownRows.size(), colNum);
                        continue;
                    }
                    ((MikuMikuExcel)unknownRows.get(i)).solve(realRowNum / unknownRows.size() + realRowNum % unknownRows.size(), colNum);
                }
            }
        }
    }

    @Override
    protected void solveStart() {
        int lastStartRowIndex = this.startRowIndex;
        int lastStartColIndex = this.startColIndex;
        if (this.rows != null) {
            for (MikuMikuExcel excel : this.rows) {
                excel.startRowIndex = lastStartRowIndex;
                excel.startColIndex = lastStartColIndex;
                excel.solveStart();
                lastStartRowIndex += excel.getRowNum().intValue();
            }
        }
        if (this.cols != null) {
            for (MikuMikuExcel excel : this.cols) {
                excel.startRowIndex = lastStartRowIndex;
                excel.startColIndex = lastStartColIndex;
                excel.solveStart();
                lastStartColIndex += excel.getColNum().intValue();
            }
        }
    }

    public static <T> MikuMikuExcel rows(Collection<T> data, Function<T, MikuMikuExcel> func) {
        return new MikuMikuExcelLayout(data.stream().map(func).collect(Collectors.toList()), null);
    }

    public static <T> MikuMikuExcel rows(Object object, String eval, Function<Function<String, String>, MikuMikuExcel> func) {
        return new MikuMikuExcelLayout(MikuMikuExcelLayout.dynamic(object, eval, func), null);
    }

    public static MikuMikuExcel rows(MikuMikuExcel ... rows) {
        return new MikuMikuExcelLayout(Arrays.asList(rows), null);
    }

    public static <T> MikuMikuExcel cols(Collection<T> data, Function<T, MikuMikuExcel> func) {
        return new MikuMikuExcelLayout(null, data.stream().map(func).collect(Collectors.toList()));
    }

    public static MikuMikuExcel cols(MikuMikuExcel ... cols) {
        return new MikuMikuExcelLayout(null, Arrays.asList(cols));
    }

    public static MikuMikuExcel cols(Object object, String eval, Function<Function<String, String>, MikuMikuExcel> func) {
        return new MikuMikuExcelLayout(null, MikuMikuExcelLayout.dynamic(object, eval, func));
    }

    private static List<MikuMikuExcel> dynamic(Object object, String eval, Function<Function<String, String>, MikuMikuExcel> func) {
        List list = (List)EvalAnalysisUtils.eval(eval, object);
        ArrayList<MikuMikuExcel> result = new ArrayList<MikuMikuExcel>();
        for (int i = 0; i < list.size(); ++i) {
            result.add(func.apply(MikuMikuExcelLayout.dynamicEval(eval, i)));
        }
        return result;
    }

    private static Function<String, String> dynamicEval(String eval, int index) {
        String str = "${";
        return v -> {
            String fv = eval.trim();
            fv = fv.substring(0, fv.length() - 1).trim();
            if (v == null) {
                return fv.concat("[").concat(String.valueOf(index)).concat("]}");
            }
            while (v.contains("${ ")) {
                v = v.replace("${ ", "${");
            }
            return v.replace("${", fv.concat("[").concat(String.valueOf(index)).concat("]."));
        };
    }
}

