/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.excel;

import cn.veasion.project.eval.EvalAnalysisUtils;
import cn.veasion.project.excel.MikuMikuExcelCell;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MikuMikuExcel {
    protected static Logger logger = LoggerFactory.getLogger(MikuMikuExcel.class);
    int startRowIndex;
    int startColIndex;
    Integer rowNum;
    Integer colNum;
    CellStyle cellStyle;
    boolean merge = true;
    BiConsumer<Workbook, Cell> afterCell;
    String dateFormat = "yyyy-MM-dd HH:mm:ss";

    public MikuMikuExcel setCellStyle(CellStyle cellStyle) {
        this.cellStyle = cellStyle;
        return this;
    }

    public MikuMikuExcel setAfterCell(BiConsumer<Workbook, Cell> afterCell) {
        this.afterCell = afterCell;
        return this;
    }

    public MikuMikuExcel setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    protected void travel(Consumer<MikuMikuExcelCell> visitor) {
    }

    protected void solve(Integer rowNum, Integer colNum) {
    }

    protected void solveStart() {
    }

    public boolean isMerge() {
        return this.merge;
    }

    public int getStartRowIndex() {
        return this.startRowIndex;
    }

    public int getStartColIndex() {
        return this.startColIndex;
    }

    public Integer getRowNum() {
        return this.rowNum;
    }

    public Integer getColNum() {
        return this.colNum;
    }

    public CellStyle getCellStyle() {
        return this.cellStyle;
    }

    public void writeTo(Workbook workbook, Sheet sheet, CellStyle defaultCellStyle) {
        this.writeTo(workbook, sheet, defaultCellStyle, null);
    }

    public void writeTo(Workbook workbook, Sheet sheet, CellStyle defaultCellStyle, Object object) {
        this.writeTo(workbook, sheet, defaultCellStyle, object, 0, 0);
    }

    public void writeTo(Workbook workbook, Sheet sheet, CellStyle defaultCellStyle, Object object, int startRowIndex, int startColIndex) {
        MikuMikuExcel excel = this;
        excel.travel(ve -> {
            if (ve.getRowNum() == null || ve.getColNum() == null) {
                throw new RuntimeException(String.format("\u5b58\u5728\u672a\u786e\u5b9a\u884c\u6570\u6216\u8005\u5217\u6570\u7684\u5355\u5143\u683c: %s", ve.getValue()));
            }
        });
        excel.solveStart();
        for (int rowIndex = 0; rowIndex < excel.getRowNum(); ++rowIndex) {
            Row row = sheet.getRow(rowIndex + startRowIndex) != null ? sheet.getRow(rowIndex + startRowIndex) : sheet.createRow(rowIndex + startRowIndex);
            excel.travel(mikuMikuExcelCell -> {
                if (mikuMikuExcelCell.getStartRowIndex() + startRowIndex == row.getRowNum()) {
                    Object value;
                    CellStyle cellStyle;
                    Cell cell = row.createCell(mikuMikuExcelCell.getStartColIndex() + startColIndex);
                    CellStyle cellStyle2 = cellStyle = mikuMikuExcelCell.getCellStyle() != null ? mikuMikuExcelCell.getCellStyle() : defaultCellStyle;
                    if (cellStyle != null) {
                        cell.setCellStyle(cellStyle);
                    }
                    if ((value = mikuMikuExcelCell.getValue()) instanceof String && object != null && ((String)value).contains("${") && (value = EvalAnalysisUtils.eval(value.toString(), object)) instanceof BiFunction) {
                        value = ((BiFunction)value).apply(workbook, cell);
                    }
                    if (value instanceof Date) {
                        cell.setCellValue(new SimpleDateFormat(this.dateFormat).format((Date)value));
                    } else {
                        cell.setCellValue(value == null ? "" : String.valueOf(value));
                    }
                    if (mikuMikuExcelCell.afterCell != null) {
                        mikuMikuExcelCell.afterCell.accept(workbook, cell);
                    }
                }
            });
        }
        excel.travel(mikuMikuExcelCell -> {
            CellStyle cellStyle;
            CellStyle cellStyle2 = cellStyle = mikuMikuExcelCell.getCellStyle() != null ? mikuMikuExcelCell.getCellStyle() : defaultCellStyle;
            if (mikuMikuExcelCell.getRowNum() > 1 || mikuMikuExcelCell.getColNum() > 1) {
                int rowNumber = mikuMikuExcelCell.getStartRowIndex() + mikuMikuExcelCell.getRowNum() + startRowIndex;
                int colNumber = mikuMikuExcelCell.getStartColIndex() + mikuMikuExcelCell.getColNum() + startColIndex;
                CellRangeAddress range = new CellRangeAddress(mikuMikuExcelCell.getStartRowIndex() + startRowIndex, rowNumber - 1, mikuMikuExcelCell.getStartColIndex() + startColIndex, colNumber - 1);
                if (mikuMikuExcelCell.isMerge()) {
                    sheet.addMergedRegion(range);
                    if (cellStyle != null) {
                        RegionUtil.setBorderBottom((BorderStyle)cellStyle.getBorderBottom(), (CellRangeAddress)range, (Sheet)sheet);
                        RegionUtil.setBorderLeft((BorderStyle)cellStyle.getBorderLeft(), (CellRangeAddress)range, (Sheet)sheet);
                        RegionUtil.setBorderRight((BorderStyle)cellStyle.getBorderRight(), (CellRangeAddress)range, (Sheet)sheet);
                        RegionUtil.setBorderTop((BorderStyle)cellStyle.getBorderTop(), (CellRangeAddress)range, (Sheet)sheet);
                    }
                } else if (cellStyle != null) {
                    for (int row = mikuMikuExcelCell.getStartRowIndex() + startRowIndex; row < rowNumber; ++row) {
                        for (int col = mikuMikuExcelCell.getStartColIndex() + startColIndex; col < colNumber; ++col) {
                            Cell cell;
                            Row sheetRow = sheet.getRow(row);
                            if (sheetRow == null) {
                                sheetRow = sheet.createRow(row);
                            }
                            if ((cell = sheetRow.getCell(col)) == null) {
                                cell = sheetRow.createCell(col);
                                cell.setCellValue("");
                            }
                            cell.setCellStyle(cellStyle);
                        }
                    }
                }
            }
        });
    }
}

