/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.excel;

import cn.veasion.project.excel.ExcelConfig;
import cn.veasion.project.excel.ExcelExportUtils;
import cn.veasion.project.excel.ExcelStyleUtils;
import cn.veasion.project.excel.MikuMikuExcel;
import cn.veasion.project.excel.MikuMikuExcelCell;
import cn.veasion.project.excel.MikuMikuExcelLayout;
import cn.veasion.project.excel.MikuMikuExcelTable;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.filechooser.FileSystemView;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExportTest {
    private static String DIR = FileSystemView.getFileSystemView().getHomeDirectory().getAbsolutePath();
    private Long id;
    private String name;
    private Integer sex;
    private Date birthday;

    public static void main(String[] args) throws Exception {
        ArrayList<ExportTest> list = new ArrayList<ExportTest>();
        list.add(ExportTest.build(1L, "\u5c0f\u660e", 1));
        list.add(ExportTest.build(2L, "\u5c0f\u7ea2", 2));
        list.add(ExportTest.build(3L, "\u5c0f\u5f20", 1));
        ExportTest.simpleTable(list);
        ExportTest.mikuMikuTable(list);
        ExportTest.mikuMikuTableOfEval(list);
        System.out.println("\u5b8c\u6210\uff01");
    }

    private static void simpleTable(List<ExportTest> list) throws Exception {
        XSSFWorkbook workbook = new XSSFWorkbook();
        ExcelConfig excelConfig = new ExcelConfig();
        excelConfig.make("id", "ID");
        excelConfig.make("name", "\u540d\u79f0");
        excelConfig.make("sex", ExcelConfig.FieldConfig.of("\u6027\u522b").callback((f, v, c) -> "1".equals(String.valueOf(v)) ? "\u7537" : "\u5973"));
        excelConfig.make("birthday", "\u751f\u65e5");
        ExcelExportUtils.createSheet((Workbook)workbook, excelConfig, list);
        workbook.write((OutputStream)new FileOutputStream(new File(DIR + "\\simple.xlsx")));
    }

    private static void mikuMikuTable(List<ExportTest> list) throws Exception {
        XSSFWorkbook workbook = new XSSFWorkbook();
        MikuMikuExcel mikuMikuExcel = MikuMikuExcelLayout.cols(MikuMikuExcelLayout.rows(MikuMikuExcelCell.dynamicCols(2, "\u6d4b\u8bd5\u8868\u683c"), MikuMikuExcelLayout.cols(MikuMikuExcelTable.of(new LinkedHashMap<String, String>(){
            {
                this.put("id", "ID");
                this.put("name", "\u540d\u79f0");
                this.put("sex", "\u6027\u522b");
                this.put("birthday", "\u751f\u65e5");
            }
        }, list, (field, value, cell) -> {
            if ("sex".equals(field)) {
                return "1".equals(String.valueOf(value)) ? "\u7537" : "\u5973";
            }
            return value;
        }, null), MikuMikuExcelLayout.rows(MikuMikuExcelCell.dynamicCols("\u6392\u884c"), MikuMikuExcelLayout.rows(list, data -> MikuMikuExcelLayout.cols(MikuMikuExcelCell.fixed(data.id), MikuMikuExcelCell.fixed(data.name))))), MikuMikuExcelCell.dynamicCols(null), MikuMikuExcelCell.dynamicCols("======== \u2193 ========"), MikuMikuExcelCell.dynamicCols(null), MikuMikuExcelLayout.rows(list, data -> MikuMikuExcelLayout.cols(MikuMikuExcelCell.dynamicCols(data.name), MikuMikuExcelCell.dynamicCols(data.birthday)))), MikuMikuExcelCell.dynamicRows("\u6d4b\u8bd51"), MikuMikuExcelLayout.rows(MikuMikuExcelCell.dynamicRows("\u6d4b\u8bd52"), MikuMikuExcelCell.dynamicRows("\u6d4b\u8bd53")));
        ExcelExportUtils.createSheet((Workbook)workbook, mikuMikuExcel);
        workbook.write((OutputStream)new FileOutputStream(new File(DIR + "\\mikuMiku.xlsx")));
    }

    private static void mikuMikuTableOfEval(List<ExportTest> list) throws Exception {
        JSONObject object = new JSONObject();
        object.put("name", (Object)"\u9879\u76ee\u540d\u79f0");
        object.put("code", (Object)"\u9879\u76ee\u7f16\u7801");
        object.put("purchaserName", (Object)"\u54c8\u54c8");
        object.put("createTime", (Object)new Date());
        object.put("headerList", list);
        object.put("bidSupperNames", (Object)"xxx\u4f9b\u5e94\u5546\u3001\u54c8\u54c8\u54c8\u4f9b\u5e94\u5546");
        object.put("itemList", Arrays.asList(JSONObject.parseObject((String)"{\"merchantName\":\"xxx\u4f9b\u5e94\u55461\",\"purchasePlanCode\":\"xxx1\",\"productNum\": 100}"), JSONObject.parseObject((String)"{\"merchantName\":\"xxx\u4f9b\u5e94\u55462\",\"purchasePlanCode\":\"xxx2\",\"productNum\": 200}")));
        object.put("quotationItems", Arrays.asList(JSONObject.parseObject((String)"{\"supplierName\":\"\u4f9b\u5e94\u55461\",\"items\":[{\"discountRate\": 0.1,\"winExp\": 1,\"productBrand\":\"\u4e2d\u56fd1\"}, {\"discountRate\": 0.11,\"winExp\": 11,\"productBrand\":\"\u4e2d\u56fd11\"}]}"), JSONObject.parseObject((String)"{\"supplierName\":\"\u4f9b\u5e94\u55462\",\"items\":[{\"discountRate\": 0.2,\"winExp\": 2,\"productBrand\":\"\u4e2d\u56fd2\"}, {\"discountRate\": 0.22,\"winExp\": 22,\"productBrand\":\"\u4e2d\u56fd22\"}]}")));
        XSSFWorkbook workbook = new XSSFWorkbook();
        MikuMikuExcel mikuMikuExcel = MikuMikuExcelLayout.rows(MikuMikuExcelCell.dynamicCols("${name}\u7efc\u5408\u8bc4\u8bae\u8868"), MikuMikuExcelLayout.cols(MikuMikuExcelCell.dynamicCols(1, null, false), MikuMikuExcelCell.fixed("\u7f16\u53f7\uff1a${code}")), MikuMikuExcelLayout.cols(MikuMikuExcelCell.dynamicCols(1, null, false), MikuMikuExcelCell.fixed("${createTime}")), MikuMikuExcelTable.ofEval(object, "${headerList}", new LinkedHashMap<String, String>(){
            {
                this.put("lineNumber", "\u5e8f\u53f7");
                this.put("id", "ID");
                this.put("name", "\u540d\u79f0");
                this.put("sex", "\u6027\u522b");
                this.put("birthday", "\u751f\u65e5");
            }
        }), MikuMikuExcelLayout.cols(MikuMikuExcelCell.fixed("\u8bc4\u8bae\u6807\u51c6"), MikuMikuExcelCell.dynamicCols(null)), MikuMikuExcelLayout.cols(MikuMikuExcelCell.fixed("\u4e2d\u6807\u89c4\u5219"), MikuMikuExcelCell.dynamicCols(null)), MikuMikuExcelLayout.cols(MikuMikuExcelCell.fixed("\u62df\u4e2d\u6807\u5355\u4f4d\uff1a"), MikuMikuExcelCell.dynamicCols("${bidSupperNames}")), MikuMikuExcelLayout.cols(MikuMikuExcelCell.fixed("\u7406\u7531"), MikuMikuExcelCell.dynamicCols(null)), MikuMikuExcelLayout.cols(MikuMikuExcelCell.fixed("\u5907\u6ce8"), MikuMikuExcelCell.dynamicCols(null)), MikuMikuExcelLayout.cols(MikuMikuExcelCell.fixed("\u603b\u7ecf\u7406\uff1a"), MikuMikuExcelCell.dynamicCols(null), MikuMikuExcelCell.fixed("\u8bc4\u6807\u4eba\u5458\uff1a"), MikuMikuExcelCell.dynamicCols(null), MikuMikuExcelCell.fixed("\u62db\u6807\u4eba"), MikuMikuExcelCell.dynamicCols("${purchaserName}"), MikuMikuExcelCell.fixed("\u76d1\u7763\u4eba\u5458")));
        MikuMikuExcel mikuMikuExcel2 = MikuMikuExcelLayout.rows(MikuMikuExcelCell.dynamicCols("${name}"), MikuMikuExcelLayout.cols(MikuMikuExcelLayout.cols(MikuMikuExcelLayout.rows(MikuMikuExcelCell.dynamicCols("\u4f9b\u5e94\u5546\u540d\u79f0").setAfterCell((wb, cell) -> ExcelStyleUtils.cloneCellStyle(wb, cell).setAlignment(HorizontalAlignment.LEFT)), MikuMikuExcelTable.ofEval(object, "${itemList}", new LinkedHashMap<String, String>(){
            {
                this.put("lineNumber", "\u5e8f\u53f7");
                this.put("merchantName", "\u91c7\u8d2d\u5355\u4f4d\u540d\u79f0");
                this.put("productName", "\u7269\u6599\u540d\u79f0");
                this.put("productSpecs", "\u7cfb\u5217");
                this.put("productUnit", "\u8ba1\u91cf\u5355\u4f4d");
                this.put("remark", "\u5907\u6ce8");
            }
        }))), MikuMikuExcelLayout.cols(object, "${quotationItems}", parent -> MikuMikuExcelLayout.rows(MikuMikuExcelCell.dynamicCols(parent.apply("${supplierName}")), MikuMikuExcelTable.ofEval(object, (String)parent.apply("${items}"), new LinkedHashMap<String, String>(){
            {
                this.put("discountRate", "\u6298\u6263\u7387");
                this.put("winExp", "\u8d28\u4fdd\u671f\uff08\u6708\uff09");
                this.put("productBrand", "\u54c1\u724c/\u4ea7\u5730");
                this.put("remark", "\u5907\u6ce8");
            }
        })))));
        Sheet sheet = ExcelExportUtils.createSheet((Workbook)workbook, mikuMikuExcel, object);
        ExcelExportUtils.appendToDown((Workbook)workbook, sheet, mikuMikuExcel2, object, 2, 2);
        ExcelExportUtils.append((Workbook)workbook, sheet, mikuMikuExcel2, object, 2, sheet.getRow(0).getLastCellNum() + 1);
        workbook.write((OutputStream)new FileOutputStream(new File(DIR + "\\mikuMikuTableOfEval.xlsx")));
    }

    private static ExportTest build(Long id, String name, Integer sex) {
        ExportTest test = new ExportTest();
        test.id = id;
        test.name = name;
        test.sex = sex;
        test.birthday = new Date();
        return test;
    }
}

