/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.excel;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelImportUtils {
    public static <T> List<T> parse(File file, Map<String, String> fieldMap, Class<T> clazz) throws IOException {
        return ExcelImportUtils.parse(file, fieldMap).toJavaList(clazz);
    }

    public static <T> List<T> parse(InputStream is, Map<String, String> fieldMap, Class<T> clazz) throws IOException {
        return ExcelImportUtils.parse(is, fieldMap).toJavaList(clazz);
    }

    public static JSONArray parse(File file, Map<String, String> fieldMap) throws IOException {
        return ExcelImportUtils.parse(Files.newInputStream(file.toPath(), new OpenOption[0]), fieldMap);
    }

    public static JSONArray parse(InputStream is, Map<String, String> fieldMap) throws IOException {
        XSSFWorkbook workbook = new XSSFWorkbook(is);
        XSSFSheet sheet = workbook.getSheetAt(0);
        return ExcelImportUtils.parse(sheet, fieldMap);
    }

    public static JSONArray parse(XSSFSheet sheet, Map<String, String> fieldMap) {
        JSONArray jsonArray = new JSONArray();
        XSSFRow headerRow = sheet.getRow(0);
        int lastRowNum = sheet.getLastRowNum();
        int lastCellNum = headerRow.getLastCellNum();
        if (lastRowNum <= 0 || lastCellNum < 0) {
            return jsonArray;
        }
        HashMap<Integer, String> cellIndexFieldMap = new HashMap<Integer, String>();
        for (int i = 0; i < lastCellNum; ++i) {
            String field;
            XSSFCell cell = headerRow.getCell(i);
            String value = cell.getStringCellValue();
            if (value == null || (field = fieldMap.get(value.trim())) == null) continue;
            cellIndexFieldMap.put(i, field);
        }
        for (int i = 1; i <= lastRowNum; ++i) {
            XSSFRow row = sheet.getRow(i);
            JSONObject jsonObject = new JSONObject();
            for (int j = 0; j < lastCellNum; ++j) {
                XSSFCell cell = row.getCell(j);
                String field = (String)cellIndexFieldMap.get(j);
                if (cell == null || field == null) continue;
                Object value = CellType.NUMERIC.equals((Object)cell.getCellType()) ? Double.valueOf(cell.getNumericCellValue()) : (CellType.BOOLEAN.equals((Object)cell.getCellType()) ? Boolean.valueOf(cell.getBooleanCellValue()) : cell.getStringCellValue());
                jsonObject.put(field, value);
            }
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray;
    }
}

