/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.excel;

import cn.veasion.project.eval.EvalAnalysisUtils;
import cn.veasion.project.excel.ExcelConfig;
import cn.veasion.project.excel.MikuMikuExcel;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelExportUtils {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static Sheet createSheet(Workbook workbook, MikuMikuExcel mikuMikuExcel) {
        return ExcelExportUtils.createSheet(workbook, mikuMikuExcel, null);
    }

    public static Sheet createSheet(Workbook workbook, MikuMikuExcel mikuMikuExcel, Object object) {
        return ExcelExportUtils.createSheet(workbook, mikuMikuExcel, object, null);
    }

    public static Sheet createSheet(Workbook workbook, MikuMikuExcel mikuMikuExcel, Object object, String sheetName) {
        return ExcelExportUtils.createSheet(workbook, mikuMikuExcel, object, sheetName, 0, 0);
    }

    public static Sheet createSheet(Workbook workbook, MikuMikuExcel mikuMikuExcel, Object object, String sheetName, int startRowIndex, int startColIndex) {
        Sheet sheet = sheetName != null ? workbook.createSheet(sheetName) : workbook.createSheet();
        mikuMikuExcel.writeTo(workbook, sheet, ExcelExportUtils.getDefaultCellStyle(workbook), object, startRowIndex, startColIndex);
        return sheet;
    }

    public static void appendToRight(Workbook workbook, Sheet sheet, MikuMikuExcel mikuMikuExcel, Object object, int gapCol, int startRowIndex) {
        short maxCellNum = 0;
        for (int i = 0; i < sheet.getLastRowNum(); ++i) {
            short number;
            if (sheet.getRow(i) == null || (number = sheet.getRow(i).getLastCellNum()) <= maxCellNum) continue;
            maxCellNum = number;
        }
        int startColIndex = maxCellNum + gapCol;
        mikuMikuExcel.writeTo(workbook, sheet, ExcelExportUtils.getDefaultCellStyle(workbook), object, startRowIndex, startColIndex);
    }

    public static void appendToDown(Workbook workbook, Sheet sheet, MikuMikuExcel mikuMikuExcel, Object object, int gapRow, int startColIndex) {
        int startRowIndex = sheet.getLastRowNum() + 1 + gapRow;
        mikuMikuExcel.writeTo(workbook, sheet, ExcelExportUtils.getDefaultCellStyle(workbook), object, startRowIndex, startColIndex);
    }

    public static void append(Workbook workbook, Sheet sheet, MikuMikuExcel mikuMikuExcel, Object object, int startRowIndex, int startColIndex) {
        mikuMikuExcel.writeTo(workbook, sheet, ExcelExportUtils.getDefaultCellStyle(workbook), object, startRowIndex, startColIndex);
    }

    public static Sheet createSheet(Workbook workbook, ExcelConfig excelConfig, List<?> list) {
        return ExcelExportUtils.createSheet(workbook, null, excelConfig, list);
    }

    public static Sheet createSheet(Workbook workbook, String sheetName, ExcelConfig excelConfig, List<?> list) {
        Sheet sheet = sheetName != null ? workbook.createSheet(sheetName) : workbook.createSheet();
        if (excelConfig.getHeadCellStyle() == null) {
            excelConfig.setHeadCellStyle(ExcelExportUtils.getDefaultCellStyle(workbook));
        }
        if (excelConfig.getDefaultCellStyle() == null) {
            excelConfig.setDefaultCellStyle(ExcelExportUtils.getDefaultCellStyle(workbook));
        }
        ExcelExportUtils.createTable(sheet, 0, 0, excelConfig, list);
        return sheet;
    }

    public static int createTable(Sheet sheet, int rowIndex, int colIndex, ExcelConfig excelConfig, List<?> list) {
        Cell cell;
        boolean hiddenHead = excelConfig.isHiddenHead();
        LinkedHashMap<String, ExcelConfig.FieldConfig> fieldMap = excelConfig.getFieldMap();
        String[] fields = fieldMap.keySet().toArray(new String[0]);
        List names = fieldMap.values().stream().map(ExcelConfig.FieldConfig::getName).collect(Collectors.toList());
        if (!hiddenHead) {
            Row row = sheet.createRow(rowIndex++);
            for (int i = 0; i < names.size(); ++i) {
                cell = row.createCell(colIndex + i);
                cell.setCellValue((String)names.get(i));
                cell.setCellStyle(excelConfig.getHeadCellStyle());
            }
        }
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            Row cellRow = sheet.createRow(rowIndex++);
            for (int j = 0; j < fields.length; ++j) {
                CellStyle cellStyle;
                cell = cellRow.createCell(colIndex + j);
                Object value = ExcelExportUtils.readField(obj, fields[j]);
                ExcelConfig.FieldConfig fieldConfig = fieldMap.get(fields[j]);
                CellStyle cellStyle2 = cellStyle = fieldConfig.getCellStyle() != null ? fieldConfig.getCellStyle() : excelConfig.getDefaultCellStyle();
                if (cellStyle != null) {
                    cell.setCellStyle(cellStyle);
                }
                if (fieldConfig.getCallback() != null) {
                    value = fieldConfig.getCallback().callback(fields[j], value, cell);
                }
                if (value == null) {
                    cell.setCellValue("");
                    continue;
                }
                if (value instanceof Date) {
                    Date date = (Date)value;
                    String dateFormat = fieldConfig.getDateFormat();
                    if (dateFormat != null) {
                        cell.setCellValue(new SimpleDateFormat(dateFormat).format(date));
                        continue;
                    }
                    cell.setCellValue(date);
                    continue;
                }
                if (value instanceof Number) {
                    DecimalFormat decimalFormat = excelConfig.getDecimalFormat();
                    if (decimalFormat != null) {
                        cell.setCellValue(decimalFormat.format(value));
                        continue;
                    }
                    cell.setCellValue(((Number)value).doubleValue());
                    continue;
                }
                cell.setCellValue(String.valueOf(value));
            }
        }
        return rowIndex;
    }

    public static void export(HttpServletResponse response, String fileName, String[] headers) throws IOException {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String header : headers) {
            map.put(header, header);
        }
        ExcelExportUtils.export(response, fileName, map, null);
    }

    public static void export(HttpServletResponse response, String fileName, LinkedHashMap<String, String> fieldMap, List<?> list) throws IOException {
        XSSFWorkbook workbook = new XSSFWorkbook();
        ExcelExportUtils.createTable((Workbook)workbook, fieldMap, list);
        ExcelExportUtils.toResponse(response, (Workbook)workbook, fileName);
    }

    public static void createTable(Workbook workbook, LinkedHashMap<String, String> fieldMap, List<?> list) {
        Sheet sheet = workbook.createSheet();
        ExcelExportUtils.createTable(sheet, ExcelExportUtils.getDefaultCellStyle(workbook), fieldMap, list);
    }

    public static void createTable(Sheet sheet, CellStyle cellStyle, LinkedHashMap<String, String> fieldMap, List<?> list) {
        Cell cell;
        int rowIndex = 0;
        String[] fields = fieldMap.keySet().toArray(new String[0]);
        ArrayList<String> names = new ArrayList<String>(fieldMap.values());
        Row row = sheet.createRow(rowIndex++);
        for (int i = 0; i < names.size(); ++i) {
            cell = row.createCell(i);
            cell.setCellValue((String)names.get(i));
            cell.setCellStyle(cellStyle);
        }
        if (list == null || list.isEmpty()) {
            return;
        }
        JSONArray jsonArray = (JSONArray)JSON.toJSON(list);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject obj = jsonArray.getJSONObject(i);
            Row cellRow = sheet.createRow(rowIndex++);
            for (int j = 0; j < fields.length; ++j) {
                cell = cellRow.createCell(j);
                Object value = obj.get((Object)fields[j]);
                cell.setCellStyle(cellStyle);
                if (value == null) {
                    cell.setCellValue("");
                    continue;
                }
                if (value instanceof Date) {
                    cell.setCellValue(new SimpleDateFormat(DATE_FORMAT).format((Date)value));
                    continue;
                }
                cell.setCellValue(String.valueOf(value));
            }
        }
    }

    public static void selectOptions(Sheet sheet, int row, int col, String ... types) {
        XSSFDataValidationHelper dvHelper2 = new XSSFDataValidationHelper((XSSFSheet)sheet);
        XSSFDataValidationConstraint dvConstraint2 = (XSSFDataValidationConstraint)dvHelper2.createExplicitListConstraint(types);
        CellRangeAddressList regions2 = new CellRangeAddressList(row, row + 5000, col, col);
        XSSFDataValidation dataValidation2 = (XSSFDataValidation)dvHelper2.createValidation((DataValidationConstraint)dvConstraint2, regions2);
        sheet.addValidationData((DataValidation)dataValidation2);
    }

    public static CellStyle getDefaultCellStyle(Workbook workbook) {
        return ExcelExportUtils.getDefaultCellStyle(workbook, false);
    }

    public static CellStyle getDefaultCellStyle(Workbook workbook, boolean border) {
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        if (border) {
            cellStyle.setBorderBottom(BorderStyle.THIN);
            cellStyle.setBorderLeft(BorderStyle.THIN);
            cellStyle.setBorderRight(BorderStyle.THIN);
            cellStyle.setBorderTop(BorderStyle.THIN);
        }
        return cellStyle;
    }

    static Object readField(Object obj, String field, Object defaultValue) {
        try {
            Object value = ExcelExportUtils.readField(obj, field);
            return value != null ? value : defaultValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    static Object readField(Object obj, String field) {
        if (obj instanceof Map && ((Map)obj).containsKey(field)) {
            return ((Map)obj).get(field);
        }
        return EvalAnalysisUtils.parse(field, obj);
    }

    public static void toResponse(HttpServletResponse response, Workbook workbook, String fileName) throws IOException {
        ExcelExportUtils.setResponseHeader(response, fileName);
        workbook.write((OutputStream)response.getOutputStream());
    }

    public static void setResponseHeader(HttpServletResponse response, String fileName) {
        try {
            fileName = URLEncoder.encode(fileName, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        response.setContentType("application/octet-stream;charset=UTF-8");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        response.addHeader("Pargam", "no-cache");
        response.addHeader("Cache-Control", "no-cache");
    }
}

