/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.excel;

import cn.veasion.project.excel.FieldCellCallback;
import java.text.DecimalFormat;
import java.util.LinkedHashMap;
import org.apache.poi.ss.usermodel.CellStyle;

public class ExcelConfig {
    private boolean hiddenHead = false;
    private CellStyle headCellStyle;
    private CellStyle defaultCellStyle;
    private DecimalFormat decimalFormat = new DecimalFormat("#.##");
    private LinkedHashMap<String, FieldConfig> fieldMap = new LinkedHashMap();

    public ExcelConfig make(String field, String name) {
        this.fieldMap.put(field, FieldConfig.of(name));
        return this;
    }

    public ExcelConfig make(String field, FieldConfig fieldConfig) {
        this.fieldMap.put(field, fieldConfig);
        return this;
    }

    public ExcelConfig make(LinkedHashMap<String, String> fieldNames) {
        fieldNames.forEach((k, v) -> this.fieldMap.put((String)k, FieldConfig.of(v)));
        return this;
    }

    public LinkedHashMap<String, FieldConfig> getFieldMap() {
        return this.fieldMap;
    }

    public CellStyle getHeadCellStyle() {
        return this.headCellStyle;
    }

    public ExcelConfig setHeadCellStyle(CellStyle headCellStyle) {
        this.headCellStyle = headCellStyle;
        return this;
    }

    public CellStyle getDefaultCellStyle() {
        return this.defaultCellStyle;
    }

    public ExcelConfig setDefaultCellStyle(CellStyle defaultCellStyle) {
        this.defaultCellStyle = defaultCellStyle;
        return this;
    }

    public DecimalFormat getDecimalFormat() {
        return this.decimalFormat;
    }

    public ExcelConfig setDecimalFormat(DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
        return this;
    }

    public ExcelConfig setHiddenHead(boolean hiddenHead) {
        this.hiddenHead = hiddenHead;
        return this;
    }

    public boolean isHiddenHead() {
        return this.hiddenHead;
    }

    public static class FieldConfig {
        private String name;
        private CellStyle cellStyle;
        private String dateFormat = "yyyy-MM-dd HH:mm:ss";
        private FieldCellCallback callback;

        public FieldConfig(String name) {
            this.name = name;
        }

        public static FieldConfig of(String name) {
            return new FieldConfig(name);
        }

        public FieldConfig cellStyle(CellStyle cellStyle) {
            this.cellStyle = cellStyle;
            return this;
        }

        public FieldConfig callback(FieldCellCallback callback) {
            this.callback = callback;
            return this;
        }

        public FieldConfig dateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public CellStyle getCellStyle() {
            return this.cellStyle;
        }

        public FieldCellCallback getCallback() {
            return this.callback;
        }

        public String getDateFormat() {
            return this.dateFormat;
        }
    }
}

