/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.eval.syntax;

import cn.veasion.project.eval.syntax.Syntax;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class WildcardSyntax
extends Syntax {
    public int min;
    public int max;
    public Syntax likeMatch;
    public Syntax notMatch;
    public Syntax inMatch;

    @Override
    protected int match(String dialog, int start, Map<String, Object> entityMap, Map<String, String> varMap, AtomicInteger counter, boolean tryNext) {
        int idx = -1;
        int maxNextIdx = -1;
        boolean like = false;
        int endIdx = Math.min(start + this.max, dialog.length());
        for (int i = start; i < endIdx; ++i) {
            int match;
            if (this.likeMatch != null) {
                if (!like && this.likeMatch.match(dialog.substring(i, endIdx), 0, entityMap, varMap, counter, tryNext) == -1) continue;
                like = true;
            }
            if (this.notMatch != null && this.notMatch.match(dialog.substring(i, endIdx), 0, entityMap, varMap, counter, tryNext) != -1) break;
            if (this.inMatch != null) {
                match = this.inMatch.match(dialog, i, entityMap, varMap, counter, tryNext);
                if (match == -1) break;
                i = match - 1;
            }
            if (i >= start + this.min - 1) {
                idx = i + 1;
                if (this.next != null) {
                    match = this.next.match(dialog, idx, entityMap, varMap, counter, true);
                    if (match != -1 || this.next.canIgnore()) {
                        maxNextIdx = idx;
                        if (tryNext || !MAX_MATCH || this.next.priority() > this.priority()) {
                            break;
                        }
                    } else if (tryNext) {
                        return -1;
                    }
                }
            }
            if (i >= start + this.max - 1) break;
        }
        return maxNextIdx != -1 ? maxNextIdx : idx;
    }

    @Override
    protected boolean canIgnore() {
        return this.min == 0;
    }

    @Override
    public List<Syntax> children() {
        if (this.likeMatch != null) {
            return Collections.singletonList(this.likeMatch);
        }
        if (this.notMatch != null) {
            return Collections.singletonList(this.notMatch);
        }
        if (this.inMatch != null) {
            return Collections.singletonList(this.inMatch);
        }
        return null;
    }

    public String toString() {
        if (this.likeMatch != null) {
            return "WildcardSyntax-LikeMatch => {min=" + this.min + ", max=" + this.max + '}';
        }
        if (this.notMatch != null) {
            return "WildcardSyntax-NotMatch => {min=" + this.min + ", max=" + this.max + '}';
        }
        if (this.inMatch != null) {
            return "WildcardSyntax-InMatch => {min=" + this.min + ", max=" + this.max + '}';
        }
        return "WildcardSyntax => {min=" + this.min + ", max=" + this.max + '}';
    }
}

