/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.eval.syntax;

import cn.veasion.project.eval.SplitGroupUtils;
import cn.veasion.project.eval.syntax.AndSyntax;
import cn.veasion.project.eval.syntax.DialogContext;
import cn.veasion.project.eval.syntax.EntitySyntax;
import cn.veasion.project.eval.syntax.LikeSyntax;
import cn.veasion.project.eval.syntax.MatchResult;
import cn.veasion.project.eval.syntax.NotEssentialSyntax;
import cn.veasion.project.eval.syntax.NumberSyntax;
import cn.veasion.project.eval.syntax.OrSyntax;
import cn.veasion.project.eval.syntax.StringSyntax;
import cn.veasion.project.eval.syntax.Syntax;
import cn.veasion.project.eval.syntax.SyntaxException;
import cn.veasion.project.eval.syntax.VarSyntax;
import cn.veasion.project.eval.syntax.WildcardSyntax;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class SyntaxParser {
    public static List<MatchResult> matchDialog(DialogContext dialogContext) {
        boolean exact = dialogContext.isExact();
        ArrayList<MatchResult> result = new ArrayList<MatchResult>();
        String dialog = dialogContext.getDialog();
        List<Syntax> templates = dialogContext.getTemplates();
        char[] chars = dialog.toCharArray();
        HashMap<Syntax, MatchResult> progress = new HashMap<Syntax, MatchResult>();
        HashMap<String, String> tempVarMap = new HashMap<String, String>();
        for (int i = 0; i < chars.length; ++i) {
            for (Syntax template : templates) {
                tempVarMap.clear();
                MatchResult cacheResult = (MatchResult)progress.get(template);
                if (cacheResult != null && (cacheResult.getLastIdx() == chars.length || i < cacheResult.getLastIdx() && !exact)) continue;
                if (cacheResult != null && i >= cacheResult.getLastIdx()) {
                    cacheResult = null;
                    progress.remove(template);
                }
                AtomicInteger counter = new AtomicInteger();
                int idx = template.match(dialog, i, dialogContext.getEntityMap(), tempVarMap, counter);
                if (idx <= i) continue;
                if (cacheResult != null && exact) {
                    if (counter.get() <= cacheResult.getCounter().get()) continue;
                    cacheResult.setWords(dialog.substring(i, idx));
                    cacheResult.setCounter(counter);
                    if (tempVarMap.size() <= 0) continue;
                    cacheResult.setVarMap(new HashMap<String, String>(tempVarMap));
                    continue;
                }
                MatchResult matchResult = new MatchResult();
                matchResult.setTemplate(template);
                matchResult.setLastIdx(idx);
                matchResult.setWords(dialog.substring(i, idx));
                matchResult.setCounter(counter);
                if (tempVarMap.size() > 0) {
                    matchResult.setVarMap(new HashMap<String, String>(tempVarMap));
                }
                result.add(matchResult);
                progress.put(template, matchResult);
            }
        }
        return result;
    }

    public static Syntax parseTemplate(String template) {
        List<SplitGroupUtils.Group> groupList = SplitGroupUtils.group(template, "[", "]", true, true);
        Syntax syntax = SyntaxParser.parseGroup(groupList);
        syntax.setTemplate(template);
        return syntax;
    }

    private static Syntax parseGroup(List<SplitGroupUtils.Group> groupList) {
        ArrayList<Syntax> list = new ArrayList<Syntax>();
        for (SplitGroupUtils.Group group : groupList) {
            if (group.getValue().trim().length() == 0) continue;
            if (group.getType() == 0) {
                list.add(new StringSyntax(group.getValue().trim()));
                continue;
            }
            try {
                list.add(SyntaxParser.buildSyntax(group));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("\u8bed\u6cd5\u9519\u8bef\uff1a" + group.getValue() + " => \u6570\u5b57\u4e0d\u5408\u89c4");
            }
            catch (SyntaxException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SyntaxException("\u672a\u77e5\u8bed\u6cd5\uff1a" + group.getValue());
            }
        }
        if (list.isEmpty()) {
            throw new SyntaxException("\u672a\u77e5\u8bed\u6cd5");
        }
        for (int i = 0; i < list.size() - 1; ++i) {
            ((Syntax)list.get(i)).setNext((Syntax)list.get(i + 1));
        }
        return list.size() == 1 ? (Syntax)list.get(0) : new AndSyntax(list);
    }

    private static Syntax buildSyntax(SplitGroupUtils.Group group) {
        String context = group.getContext().trim();
        String value = group.getValue();
        if (value.startsWith("[W:")) {
            String[] number;
            context = context.substring(2);
            WildcardSyntax syntax = new WildcardSyntax();
            boolean isLike = false;
            boolean isIn = false;
            int idx = context.indexOf("{", 2);
            if (idx != -1) {
                switch (context.charAt(idx - 1)) {
                    case '~': {
                        isLike = true;
                        break;
                    }
                    case '>': {
                        isIn = true;
                        break;
                    }
                    case '^': {
                        break;
                    }
                    default: {
                        throw new SyntaxException("\u901a\u914d\u7b26\u8bed\u6cd5\u9519\u8bef\uff1a" + value + " ==> " + context.substring(idx - 1, 2));
                    }
                }
                if (!context.endsWith("}")) {
                    throw new SyntaxException("\u901a\u914d\u7b26" + (isLike ? "\u5305\u542b" : (isIn ? "\u9650\u5b9a" : "\u5426\u5b9a")) + "\u8bed\u6cd5\u9519\u8bef\uff1a" + value + " => \u7f3a\u5c11 }");
                }
                number = context.substring(0, idx - 1).split("-");
                String sub = context.substring(idx + 1, context.length() - 1);
                if (sub.length() > 0) {
                    if (isLike) {
                        syntax.likeMatch = SyntaxParser.parseTemplate(sub);
                    } else if (isIn) {
                        syntax.inMatch = SyntaxParser.parseTemplate(sub);
                    } else {
                        syntax.notMatch = SyntaxParser.parseTemplate(sub);
                    }
                }
            } else {
                number = context.split("-");
            }
            if (number.length == 1) {
                syntax.max = syntax.min = Integer.parseInt(number[0]);
            } else if (number.length == 2) {
                syntax.min = Integer.parseInt(number[0]);
                syntax.max = Integer.parseInt(number[1]);
                if (syntax.min > syntax.max) {
                    throw new SyntaxException("\u901a\u914d\u7b26\u8bed\u6cd5\u683c\u5f0f\u9519\u8bef\uff1b" + value + " ==> \u6700\u5c0f\u5339\u914d\u4e2a\u6570\u4e0d\u80fd\u5927\u4e8e" + syntax.max);
                }
            } else {
                throw new SyntaxException("\u901a\u914d\u7b26\u8bed\u6cd5\u683c\u5f0f\u9519\u8bef\uff1b" + value);
            }
            return syntax;
        }
        if (value.startsWith("[N:")) {
            context = context.substring(2);
            NumberSyntax syntax = new NumberSyntax();
            String[] number = context.split("-");
            if (number.length == 1) {
                syntax.max = syntax.min = Integer.parseInt(number[0]);
            } else if (number.length == 2) {
                syntax.min = Integer.parseInt(number[0]);
                syntax.max = Integer.parseInt(number[1]);
                if (syntax.min > syntax.max) {
                    throw new SyntaxException("\u4efb\u610f\u6570\u5b57\u8bed\u6cd5\u683c\u5f0f\u9519\u8bef\uff1b" + value + " ==> \u6700\u5c0f\u5339\u914d\u4e2a\u6570\u4e0d\u80fd\u5927\u4e8e" + syntax.max);
                }
            } else {
                throw new SyntaxException("\u4efb\u610f\u6570\u5b57\u8bed\u6cd5\u683c\u5f0f\u9519\u8bef\uff1b" + value);
            }
            return syntax;
        }
        if (value.startsWith("[@")) {
            if (group.getChildren() != null && group.getChildren().size() > 0) {
                throw new SyntaxException("\u5b9e\u4f53\u8bed\u6cd5\u683c\u5f0f\u9519\u8bef\uff1b" + value);
            }
            if ((context = context.substring(1).trim()).length() == 0) {
                throw new SyntaxException("\u6a21\u7cca\u5339\u914d\u8bed\u6cd5\u683c\u5f0f\u9519\u8bef\uff1b" + value);
            }
            return new EntitySyntax(context);
        }
        if (value.startsWith("[~")) {
            if (group.getChildren() != null && group.getChildren().size() > 0) {
                throw new SyntaxException("\u6a21\u7cca\u5339\u914d\u8bed\u6cd5\u683c\u5f0f\u9519\u8bef\uff1b" + value);
            }
            if ((context = context.substring(1).trim()).length() == 0) {
                throw new SyntaxException("\u6a21\u7cca\u5339\u914d\u8bed\u6cd5\u683c\u5f0f\u9519\u8bef\uff1b" + value);
            }
            return new LikeSyntax(context);
        }
        if (value.startsWith("[#")) {
            int idx = (context = context.substring(1).trim()).indexOf(":");
            if (idx == -1) {
                throw new SyntaxException("\u53d8\u91cf\u8bed\u6cd5\u683c\u5f0f\u9519\u8bef\uff1a" + value + " => \u7f3a\u5c11:");
            }
            String var = context.substring(0, idx);
            String sub = context.substring(idx + 1).trim();
            if (sub.length() == 0) {
                throw new SyntaxException("\u53d8\u91cf\u8bed\u6cd5\u683c\u5f0f\u9519\u8bef\uff1a" + value + " => \u7f3a\u5c11\u4e3b\u4f53");
            }
            return new VarSyntax(var, SyntaxParser.parseTemplate(sub));
        }
        if (value.endsWith("?]")) {
            if ((context = context.substring(0, context.length() - 1).trim()).length() == 0) {
                throw new SyntaxException("\u975e\u5fc5\u9009\u8bed\u6cd5\u683c\u5f0f\u9519\u8bef\uff1b" + value);
            }
            return new NotEssentialSyntax(SyntaxParser.parseTemplate(context));
        }
        if (group.getChildren() != null && group.getChildren().size() > 0) {
            return SyntaxParser.parseSyntaxChildren(group);
        }
        String[] split = context.split("\\|");
        List<Syntax> children = Arrays.stream(split).map(s -> new StringSyntax(s.trim())).filter(s -> s.str.length() > 0).collect(Collectors.toList());
        if (children.size() == 0) {
            throw new SyntaxException("\u53ef\u9009\u8bed\u6cd5\u683c\u5f0f\u9519\u8bef\uff1b" + value);
        }
        return new OrSyntax(children);
    }

    private static Syntax parseSyntaxChildren(SplitGroupUtils.Group group) {
        ArrayList<Syntax> list = new ArrayList<Syntax>();
        ArrayList<Syntax> tempAnds = new ArrayList<Syntax>();
        int orNum = 0;
        for (SplitGroupUtils.Group child : group.getChildren()) {
            String v = child.getValue().trim();
            if (v.length() == 0) continue;
            if (child.getType() == 1) {
                tempAnds.add(SyntaxParser.buildSyntax(child));
                continue;
            }
            if ("|".equals(v)) {
                if (tempAnds.size() > 0) {
                    if (tempAnds.size() == 1) {
                        list.add((Syntax)tempAnds.get(0));
                    } else {
                        list.add(new AndSyntax(tempAnds));
                    }
                    tempAnds = new ArrayList();
                } else if (orNum != 0) {
                    throw new SyntaxException("\u53ef\u9009\u8bed\u6cd5\u683c\u5f0f\u9519\u8bef\uff1b" + group.getValue() + " ==> " + v);
                }
                orNum = 1;
                continue;
            }
            if (v.contains("|")) {
                if (v.startsWith("|")) {
                    if (tempAnds.size() > 0) {
                        if (tempAnds.size() == 1) {
                            list.add((Syntax)tempAnds.get(0));
                        } else {
                            list.add(new AndSyntax(tempAnds));
                        }
                        tempAnds = new ArrayList();
                    } else if (orNum != 0) {
                        throw new SyntaxException("\u53ef\u9009\u8bed\u6cd5\u683c\u5f0f\u9519\u8bef\uff1b" + group.getValue() + " ==> " + v);
                    }
                    v = v.substring(1);
                }
                boolean hasEnd = false;
                if (v.endsWith("|")) {
                    hasEnd = true;
                    v = v.substring(0, v.length() - 1);
                }
                List vs = Arrays.stream(v.split("\\|")).map(String::trim).collect(Collectors.toList());
                for (int i = 0; i < vs.size(); ++i) {
                    String s = (String)vs.get(i);
                    if (s.length() == 0) {
                        throw new SyntaxException("\u53ef\u9009\u8bed\u6cd5\u683c\u5f0f\u9519\u8bef\uff1b" + group.getValue() + " ==> " + v);
                    }
                    if (!hasEnd && i == vs.size() - 1) {
                        tempAnds.add(new StringSyntax(s));
                        continue;
                    }
                    if ((hasEnd || orNum > 0) && i == 0) {
                        tempAnds.add(new StringSyntax(s));
                        if (tempAnds.size() == 1) {
                            list.add((Syntax)tempAnds.get(0));
                        } else {
                            list.add(new AndSyntax(tempAnds));
                        }
                        tempAnds = new ArrayList();
                        continue;
                    }
                    list.add(new StringSyntax(s));
                }
                if (!hasEnd) continue;
                orNum = 1;
                continue;
            }
            orNum = 0;
            tempAnds.add(new StringSyntax(v));
        }
        if (tempAnds.size() > 0) {
            if (tempAnds.size() == 1) {
                list.add((Syntax)tempAnds.get(0));
            } else {
                list.add(new AndSyntax(tempAnds));
            }
        }
        if (list.isEmpty()) {
            throw new SyntaxException("\u53ef\u9009\u8bed\u6cd5\u683c\u5f0f\u9519\u8bef\uff1b" + group.getValue());
        }
        return new OrSyntax(list);
    }

    public static int getEndIdx(char[] chars, int start, int endIdx) {
        for (int i = start + 1; i < endIdx; ++i) {
            if (!SyntaxParser.isSplitChar(chars[i])) continue;
            endIdx = i;
            break;
        }
        return endIdx;
    }

    public static boolean isSplitChar(char c) {
        switch (c) {
            case '\n': 
            case '!': 
            case ',': 
            case '.': 
            case ';': 
            case '?': 
            case '~': 
            case '\u3002': 
            case '\uff01': 
            case '\uff0c': 
            case '\uff1b': 
            case '\uff1f': {
                return true;
            }
        }
        return false;
    }
}

