/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.eval.syntax;

import cn.veasion.project.eval.syntax.StringSyntax;
import cn.veasion.project.eval.syntax.Syntax;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class OrSyntax
extends Syntax {
    private static final int OR_STRING_MAX = 8;
    public List<Syntax> syntaxList;

    public OrSyntax(List<Syntax> syntaxList) {
        if (syntaxList.size() >= 8) {
            ArrayList<String> stringList = new ArrayList<String>();
            for (int i = 0; i < syntaxList.size(); ++i) {
                Syntax syntax = syntaxList.get(i);
                if (syntax instanceof StringSyntax) {
                    stringList.add(((StringSyntax)syntax).str);
                    continue;
                }
                if (stringList.size() >= 8) {
                    int removeIdx = i - stringList.size();
                    for (int j = 0; j < stringList.size(); ++j) {
                        syntaxList.remove(removeIdx);
                    }
                    syntaxList.add(removeIdx, new OrStringSyntax(stringList));
                    i = removeIdx;
                }
                stringList.clear();
            }
            if (stringList.size() >= 8) {
                int removeIdx = syntaxList.size() - stringList.size();
                for (int j = 0; j < stringList.size(); ++j) {
                    syntaxList.remove(removeIdx);
                }
                syntaxList.add(removeIdx, new OrStringSyntax(stringList));
            }
        }
        this.syntaxList = syntaxList;
    }

    @Override
    protected int match(String dialog, int start, Map<String, Object> entityMap, Map<String, String> varMap, AtomicInteger counter, boolean tryNext) {
        int idx = -1;
        for (Syntax syntax : this.syntaxList) {
            AtomicInteger _counter;
            idx = syntax.match(dialog, start, entityMap, varMap, _counter = tryNext ? null : new AtomicInteger(), tryNext);
            if (idx == -1) continue;
            if (tryNext || counter == null) break;
            counter.addAndGet(_counter.get());
            break;
        }
        return idx;
    }

    @Override
    public List<Syntax> children() {
        return this.syntaxList;
    }

    @Override
    protected boolean canIgnore() {
        for (Syntax syntax : this.syntaxList) {
            if (!syntax.canIgnore()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "OrSyntax";
    }

    static class OrStringSyntax
    extends Syntax {
        private Map<Character, List<String>> treeMap = new HashMap<Character, List<String>>();

        public OrStringSyntax(List<String> list) {
            for (String s : list) {
                this.treeMap.compute(Character.valueOf(s.charAt(0)), (k, v) -> {
                    if (v == null) {
                        v = new ArrayList<String>();
                    }
                    v.add(s);
                    return v;
                });
            }
        }

        @Override
        protected int match(String dialog, int start, Map<String, Object> entityMap, Map<String, String> varMap, AtomicInteger counter, boolean tryNext) {
            if (start >= dialog.length()) {
                return -1;
            }
            List<String> list = this.treeMap.get(Character.valueOf(dialog.charAt(start)));
            if (list != null) {
                for (String s : list) {
                    if (!OrStringSyntax.startsWith(dialog, start, s)) continue;
                    return start + s.length();
                }
            }
            return -1;
        }

        public String toString() {
            return "OrStringSyntax => {" + this.treeMap.values().stream().flatMap(Collection::stream).collect(Collectors.joining("|")) + '}';
        }
    }
}

