/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.eval;

import cn.veasion.project.eval.SplitGroupUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EvalAnalysisUtils {
    private static final Map<Class<?>, Map<String, Method>> METHOD_CACHE_MAP = new ConcurrentHashMap();
    private static final Map<Class<?>, Map<String, Field>> FIELD_CACHE_MAP = new ConcurrentHashMap();
    private static final Map<Class<?>, Map<String, Method>> GET_METHOD_CACHE_MAP = new ConcurrentHashMap();
    private static final String _L = "[";
    private static final String _R = "]";
    private static final Pattern EL_PATTERN = Pattern.compile("\\$\\{([^}]*)\\}");
    private static final Pattern EL_UNIQUE_PATTERN = Pattern.compile("^\\$\\{([^}]*)\\}$");
    private static final Pattern LR_PATTERN = Pattern.compile("([^\\[\\]]*)\\[([^\\[\\]]*)\\]");

    public static void main(String[] args) {
        HashMap<String, Object> object = new HashMap<String, Object>();
        object.put("age", 18);
        object.put("var", "name");
        object.put("idx", 1);
        HashMap<String, Object> user = new HashMap<String, Object>();
        user.put("name", "veasion");
        user.put("var", "name");
        user.put("index", 0);
        object.put("list", new Object[]{user, new Integer("100")});
        object.put("common", key -> "common_" + key);
        System.out.println("\u53d8\u91cf\u89e3\u6790\uff1a");
        System.out.println(EvalAnalysisUtils.parse("name", user));
        System.out.println(EvalAnalysisUtils.parse("list[0]", object));
        System.out.println(EvalAnalysisUtils.parse("list[0].name", object));
        System.out.println(EvalAnalysisUtils.parse("$[0]", new String[]{"index0"}));
        System.out.println("\u8868\u8fbe\u5f0f\uff1a");
        System.out.println(EvalAnalysisUtils.eval("${abc|default}", object));
        System.out.println(EvalAnalysisUtils.eval("${list[0]}", object));
        System.out.println(EvalAnalysisUtils.eval("${list[idx].value}", object));
        System.out.println(EvalAnalysisUtils.eval("${common.test}", object));
        System.out.println(EvalAnalysisUtils.eval("${ $[0] }-${ $[1] }", new String[]{"name1", "name2"}));
        System.out.println(EvalAnalysisUtils.eval("name: ${list[0][list[list[0].index].var]}", object));
        System.out.println(EvalAnalysisUtils.eval("name1: ${list[0][var]}, name2: ${list[0]['name']}", object));
        System.out.println(EvalAnalysisUtils.evalMultiple("${age}, ${list[0].name}, ${$[0]}, ${name}, ${xxx}", object, new int[]{10, 20}, user, key -> "default_" + key));
    }

    public static Object evalMultiple(String str, Object ... objects) {
        return EvalAnalysisUtils.eval(str, key -> {
            for (Object object : objects) {
                if (object == null) continue;
                Object val = EvalAnalysisUtils.parseObject(object, key);
                if (val == null && "$".equals(key) && EvalAnalysisUtils.isArray(object)) {
                    val = object;
                }
                if (val == null) continue;
                return val;
            }
            return null;
        });
    }

    public static Object eval(String str, Object object) {
        Matcher matcher;
        if (str == null) {
            return null;
        }
        if ("".equals(str.trim())) {
            return str;
        }
        if (str.startsWith("${") && str.endsWith("}") && (matcher = EL_UNIQUE_PATTERN.matcher(str)).find()) {
            return EvalAnalysisUtils.parse(matcher.group(1), object);
        }
        int index = 0;
        StringBuilder sb = new StringBuilder();
        matcher = EL_PATTERN.matcher(str);
        while (matcher.find()) {
            sb.append(str.substring(index, matcher.start()));
            sb.append(EvalAnalysisUtils.parse(matcher.group(1), object));
            index = matcher.end();
        }
        sb.append(str.substring(index));
        return sb.toString();
    }

    public static Object parse(String text, Object object) {
        if (text == null) {
            return null;
        }
        if ("".equals(text.trim())) {
            return text;
        }
        String str = text.trim();
        String defaultValue = null;
        int defIndex = str.lastIndexOf("|");
        if (defIndex > 0) {
            defaultValue = str.substring(defIndex + 1).trim();
            str = str.substring(0, defIndex);
        }
        Object result = EvalAnalysisUtils.hasBrackets(str) ? EvalAnalysisUtils.parseGroup(SplitGroupUtils.group(str, _L, _R, true), object) : EvalAnalysisUtils.parseConsecutive(object, str);
        return result != null ? result : defaultValue;
    }

    private static Object parseGroup(List<SplitGroupUtils.Group> groupList, Object object) {
        StringBuilder sb = new StringBuilder();
        for (SplitGroupUtils.Group g : groupList) {
            if (g.getChildren() != null && !g.getChildren().isEmpty()) {
                Object result = EvalAnalysisUtils.parseGroup(g.getChildren(), object);
                if (result == null) {
                    throw new RuntimeException(String.format("%s is null", g.getContext()));
                }
                sb.append(_L);
                if (EvalAnalysisUtils.isNumber(result)) {
                    sb.append(result);
                } else {
                    sb.append("'").append(result).append("'");
                }
                sb.append(_R);
                continue;
            }
            sb.append(g.getValue());
        }
        return EvalAnalysisUtils.parseConsecutive(object, sb.toString());
    }

    private static Object parseConsecutive(Object object, String str) {
        String key;
        String[] split;
        Object result = object;
        String[] stringArray = split = str.trim().split("\\.");
        int n = stringArray.length;
        for (int i = 0; i < n && (result = EvalAnalysisUtils.hasBrackets(key = stringArray[i]) ? EvalAnalysisUtils.parseBrackets(object, result, key) : EvalAnalysisUtils.parseObject(result, key)) != null; ++i) {
        }
        return result;
    }

    private static Object parseBrackets(Object object, Object result, String text) {
        Matcher matcher = LR_PATTERN.matcher(text);
        while (matcher.find()) {
            String group = matcher.group();
            String groupKey = matcher.group(1).trim();
            text = matcher.group(2);
            if (!("".equals(groupKey) || "$".equals(groupKey) && EvalAnalysisUtils.isArray(result) && EvalAnalysisUtils.isNumber(text))) {
                result = EvalAnalysisUtils.parseObject(result, groupKey);
            }
            if (EvalAnalysisUtils.isNumber(text)) {
                result = EvalAnalysisUtils.parseArray(result, group, Integer.parseInt(text));
            } else if (text.startsWith("'") && text.endsWith("'")) {
                result = EvalAnalysisUtils.parseObject(result, text.substring(1, text.length() - 1));
            } else {
                Object varValue = EvalAnalysisUtils.parseObject(object, text);
                if (varValue == null) {
                    throw new RuntimeException(String.format("%s \u53d8\u91cf\u4e0d\u5b58\u5728 => %s", group, text));
                }
                String var = String.valueOf(varValue);
                result = EvalAnalysisUtils.isNumber(var) && EvalAnalysisUtils.isArray(result) ? EvalAnalysisUtils.parseArray(result, group, Integer.parseInt(var)) : EvalAnalysisUtils.parseObject(result, var);
            }
            if (result != null) continue;
            break;
        }
        return result;
    }

    private static Object parseArray(Object object, String text, int index) {
        if (object != null) {
            try {
                if (object instanceof Collection) {
                    return ((Collection)object).toArray()[index];
                }
                if (object instanceof Object[]) {
                    Object[] array = (Object[])object;
                    return array[index];
                }
                if (object.getClass().isArray()) {
                    return Array.get(object, index);
                }
                throw new RuntimeException(String.format("%s (%s) \u4e0d\u662f\u4e00\u4e2a array \u7c7b\u578b => %s", object, object.getClass().getName(), text));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new RuntimeException(String.format("%s \u6570\u7ec4\u8d8a\u754c => %s", object, text));
            }
        }
        return null;
    }

    private static Object parseObject(Object object, String key) {
        if (object instanceof Map) {
            return ((Map)object).get(key);
        }
        if (object instanceof Function) {
            return ((Function)object).apply(key);
        }
        try {
            return EvalAnalysisUtils.reflect(object, key);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean hasBrackets(String text) {
        return text != null && text.contains(_L) && text.contains(_R);
    }

    private static boolean isNumber(Object object) {
        return object != null && object.toString().matches("\\d+");
    }

    private static boolean isArray(Object object) {
        return object != null && (object instanceof Collection || object.getClass().isArray());
    }

    private static Object reflect(Object object, String key) throws InvocationTargetException, IllegalAccessException {
        Method[] methods;
        Class<?> clazz = object.getClass();
        Method methodCache = (Method)EvalAnalysisUtils.getCache(METHOD_CACHE_MAP, clazz, key);
        if (methodCache != null) {
            return methodCache.invoke(object, new Object[0]);
        }
        Field fieldCache = (Field)EvalAnalysisUtils.getCache(FIELD_CACHE_MAP, clazz, key);
        if (fieldCache != null) {
            return fieldCache.get(object);
        }
        Method getMethodCache = (Method)EvalAnalysisUtils.getCache(GET_METHOD_CACHE_MAP, clazz, key);
        if (getMethodCache != null) {
            return getMethodCache.invoke(object, key);
        }
        Method getMethod = null;
        for (Method method : methods = clazz.getMethods()) {
            String methodName = method.getName();
            if (!Modifier.isPublic(method.getModifiers())) continue;
            if (method.getParameterCount() == 0 && methodName.equalsIgnoreCase("get" + key)) {
                EvalAnalysisUtils.putCache(METHOD_CACHE_MAP, clazz, key, method);
                return method.invoke(object, new Object[0]);
            }
            if (!"get".equals(methodName) || method.getParameterCount() != 1 || !method.getParameterTypes()[0].isAssignableFrom(key.getClass())) continue;
            getMethod = method;
        }
        Field field = EvalAnalysisUtils.getByField(clazz, key);
        if (field != null) {
            field.setAccessible(true);
            if (field.getName().equals(key)) {
                EvalAnalysisUtils.putCache(FIELD_CACHE_MAP, clazz, key, field);
                return field.get(object);
            }
        }
        if (getMethod != null) {
            EvalAnalysisUtils.putCache(GET_METHOD_CACHE_MAP, clazz, key, getMethod);
            return getMethod.invoke(object, key);
        }
        return null;
    }

    private static Field getByField(Class<?> clazz, String key) {
        while (clazz != null) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!field.getName().equals(key)) continue;
                return field;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private static <T> T getCache(Map<Class<?>, Map<String, T>> cacheMap, Class<?> clazz, String key) {
        Map<String, T> clazzMap = cacheMap.get(clazz);
        return clazzMap != null ? (T)clazzMap.get(key) : null;
    }

    private static <T> void putCache(Map<Class<?>, Map<String, T>> cacheMap, Class<?> clazz, String key, T value) {
        cacheMap.compute(clazz, (k, v) -> {
            if (v == null) {
                v = new ConcurrentHashMap<String, Object>();
            }
            v.put(key, value);
            return v;
        });
    }
}

