/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.eval;

import cn.veasion.project.eval.EvalAnalysisUtils;
import cn.veasion.project.eval.SplitGroupUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public class CondAnalysisUtils {
    private static final String SPLIT_OR = "\\|\\|";
    private static final String SPLIT_AND = "&&";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String _OR = "||";
    private static final String _AND = "&&";

    public static void main(String[] args) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("orderSource", 0);
        map.put("orderStatus", 1010);
        map.put("orderPaymentType", 1);
        BiConsumer<String, Object> eval = (str, object) -> System.out.println(str + "\n==> " + CondAnalysisUtils.eval(str, object));
        eval.accept("!false", map);
        eval.accept("1==1", map);
        eval.accept("'abc' == 'abc'", map);
        eval.accept("orderType == null", map);
        eval.accept("orderPaymentType not in(2,3)", map);
        eval.accept("orderStatus in (1999,9000) && orderSource != 5", map);
        eval.accept("orderStatus in (1010,1060,1070) && !(orderSource in (1,5))", map);
        eval.accept("orderPaymentType == 1 && orderStatus == 1010 && orderSource in (0,1,6,7,11,13)", map);
        eval.accept("orderPaymentType == 2 && orderStatus == 1010 && orderSource in (0,1,6,11,13)", map);
        eval.accept("orderPaymentType == 0 && orderStatus == 1010 || !(orderPaymentType in(1,2) && orderStatus != 9000) || orderStatus > 0", map);
    }

    public static boolean eval(String str, Object object) {
        return CondAnalysisUtils.groupAnalysis(SplitGroupUtils.group(str, "(", ")", true), object);
    }

    private static boolean groupAnalysis(List<SplitGroupUtils.Group> list, Object object) {
        StringBuilder sb = new StringBuilder();
        for (SplitGroupUtils.Group group : list) {
            String context = group.getContext();
            if (group.getType() == 1) {
                if (group.getChildren() != null) {
                    sb.append(CondAnalysisUtils.groupAnalysis(group.getChildren(), object));
                    continue;
                }
                if (context.contains("&&") || context.contains(_OR)) {
                    sb.append(CondAnalysisUtils.orAnalysis(context, object));
                    continue;
                }
                sb.append(group.getValue());
                continue;
            }
            sb.append(context);
        }
        return CondAnalysisUtils.orAnalysis(sb.toString(), object);
    }

    private static boolean orAnalysis(String str, Object object) {
        String[] orSplits;
        for (String orSplit : orSplits = str.split(SPLIT_OR)) {
            if (!CondAnalysisUtils.andAnalysis(orSplit, object)) continue;
            return true;
        }
        return false;
    }

    private static boolean andAnalysis(String str, Object object) {
        String[] andSplits;
        for (String andSplit : andSplits = str.split("&&")) {
            if (CondAnalysisUtils.oneAnalysis(andSplit, object)) continue;
            return false;
        }
        return true;
    }

    private static boolean oneAnalysis(String str, Object object) {
        String text = str.trim();
        boolean non = text.startsWith("!");
        if (non) {
            text = text.substring(text.indexOf("!") + 1);
        }
        if (TRUE.equals(text)) {
            return !non;
        }
        if (FALSE.equals(text)) {
            return non;
        }
        Operator operator = null;
        String eval = null;
        String value = null;
        char[] chars = text.toCharArray();
        block5: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case ' ': 
                case '!': 
                case '<': 
                case '=': 
                case '>': {
                    operator = CondAnalysisUtils.matchesOperator(chars, i);
                    if (operator != null) {
                        eval = text.substring(0, i).trim();
                        value = text.substring(i + operator.opt.length()).trim();
                        break block5;
                    }
                }
                default: {
                    continue block5;
                }
            }
        }
        if (operator == null) {
            throw new RuntimeException(String.format("\u8868\u8fbe\u5f0f\u683c\u5f0f\u9519\u8bef: %s", str));
        }
        Object result = null;
        try {
            if ("".equals(eval) || CondAnalysisUtils.isString(eval)) {
                return operator.test(CondAnalysisUtils.getString(eval), value);
            }
            if (CondAnalysisUtils.isNumber(eval) && CondAnalysisUtils.isNumber(value)) {
                return operator.test(eval, value);
            }
            result = EvalAnalysisUtils.parse(eval, object);
            return operator.test(result, value);
        }
        catch (Exception e) {
            if (result != null) {
                throw new RuntimeException(String.format("\u8868\u8fbe\u5f0f\u9519\u8bef\uff1a%s ==> %s %s %s", str, String.valueOf(result), operator.opt, value), e);
            }
            throw new RuntimeException(String.format("\u8868\u8fbe\u5f0f\u9519\u8bef\uff1a%s", str), e);
        }
    }

    private static boolean isNumber(String str) {
        return str != null && str.matches("\\d+");
    }

    private static boolean isString(String str) {
        return str != null && (str.startsWith("'") && str.endsWith("'") || str.startsWith("\"") && str.endsWith("\""));
    }

    private static String getString(String str) {
        if (CondAnalysisUtils.isString(str)) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    private static Operator matchesOperator(char[] chars, int i) {
        int len = chars.length;
        List<Operator> operators = Operator.START_OPERATOR.get(Character.valueOf(chars[i]));
        if (operators == null) {
            return null;
        }
        for (Operator operator : operators) {
            int optLen = operator.opt.length();
            if (i + optLen > len) continue;
            boolean eq = true;
            for (int j = 0; j < optLen; ++j) {
                if (chars[i + j] == operator.opt.charAt(j)) continue;
                eq = false;
                break;
            }
            if (!eq) continue;
            if (operator.isWord) {
                if (i + optLen == len) {
                    return operator;
                }
                switch (chars[i + optLen]) {
                    case ' ': 
                    case '\"': 
                    case '\'': 
                    case '(': {
                        return operator;
                    }
                }
                continue;
            }
            return operator;
        }
        return null;
    }

    static enum Operator {
        EQ("==", (object, s) -> s.equalsIgnoreCase(String.valueOf(object))),
        NEQ("!=", (object, s) -> !EQ.test(object, (String)s)),
        GT(">", (object, s) -> Optional.ofNullable(object).map(String::valueOf).map(o -> new BigDecimal((String)o).compareTo(new BigDecimal((String)s)) > 0).orElse(false)),
        LT("<", (object, s) -> Optional.ofNullable(object).map(String::valueOf).map(o -> new BigDecimal((String)o).compareTo(new BigDecimal((String)s)) < 0).orElse(false)),
        GTE(">=", (object, s) -> Optional.ofNullable(object).map(String::valueOf).map(o -> new BigDecimal((String)o).compareTo(new BigDecimal((String)s)) >= 0).orElse(false)),
        LTE("<=", (object, s) -> Optional.ofNullable(object).map(String::valueOf).map(o -> new BigDecimal((String)o).compareTo(new BigDecimal((String)s)) <= 0).orElse(false)),
        IN(" in", true, (object, s) -> {
            if (object == null) {
                return false;
            }
            if (s.startsWith("(") && s.endsWith(")")) {
                s = s.substring(1, s.length() - 1);
            }
            HashSet<String> set = new HashSet<String>();
            for (String str : s.split(",")) {
                set.add(CondAnalysisUtils.getString(str.trim()));
            }
            return set.contains(String.valueOf(object));
        }),
        NOT_IN(" not in", true, (object, s) -> !IN.test(object, (String)s));

        private String opt;
        private boolean isWord;
        private BiFunction<Object, String, Boolean> function;
        public static final Map<Character, List<Operator>> START_OPERATOR;

        private Operator(String opt, BiFunction<Object, String, Boolean> function) {
            this(opt, false, function);
        }

        private Operator(String opt, boolean isWord, BiFunction<Object, String, Boolean> function) {
            this.opt = opt;
            this.isWord = isWord;
            this.function = function;
            if (isWord && !opt.startsWith(" ")) {
                throw new RuntimeException("isWord\u64cd\u4f5c\u7b26\u5fc5\u987b\u4ee5\u7a7a\u683c\u5f00\u5934: " + opt);
            }
        }

        public boolean test(Object object, String s) {
            return Boolean.TRUE.equals(this.function.apply(object, CondAnalysisUtils.getString(s)));
        }

        static {
            START_OPERATOR = new HashMap<Character, List<Operator>>(Operator.values().length);
            for (Operator value : Operator.values()) {
                START_OPERATOR.compute(Character.valueOf(value.opt.charAt(0)), (k, v) -> {
                    if (v == null) {
                        v = new ArrayList<Operator>();
                    }
                    v.add(value);
                    return v;
                });
            }
            START_OPERATOR.values().forEach(list -> list.sort(Collections.reverseOrder(Comparator.comparingInt(o -> o.opt.length()))));
        }
    }
}

