/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.eval;

import cn.veasion.project.eval.EvalAnalysisUtils;
import cn.veasion.project.eval.SplitGroupUtils;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class CalculatorUtils {
    private static final int SCALE = 6;
    private static final int ROUNDING_MODE = 4;
    private static final Pattern OPERATOR = Pattern.compile("[+\\-*/\u00d7\u00f7%\u221a^]");
    public static final Pattern NUMBER = Pattern.compile("-?\\d+(\\.\\d+)?");

    public static void main(String[] args) {
        CalculatorUtils.testCalculate("-2");
        CalculatorUtils.testCalculate("\u221a8");
        CalculatorUtils.testCalculate("2^3");
        CalculatorUtils.testCalculate("10%6");
        CalculatorUtils.testCalculate("1+(-4)");
        CalculatorUtils.testCalculate("\u221a(3*3)");
        CalculatorUtils.testCalculate("2\u00d73\u00f73");
        CalculatorUtils.testCalculate("1+3\u221a(3*3*3)");
        CalculatorUtils.testCalculate("2+5*2-6/3");
        CalculatorUtils.testCalculate("(1+2+3)^2+4");
        CalculatorUtils.testCalculate("2+5*(2-6*(3+1))/3");
        CalculatorUtils.testCalculate("4.99+(5.99+6.99)*1.06^2+\u221a4");
        System.out.println("======================");
        JSONObject temp1 = JSONObject.parseObject((String)"{\"a\":1,\"b\":2,\"c\":3,\"aa\":-1,\"bb\":-2,\"cc\":-3,\"d\":4.99,\"s\":8}");
        CalculatorUtils.testCalculate(temp1, "-b");
        CalculatorUtils.testCalculate(temp1, "\u221as");
        CalculatorUtils.testCalculate(temp1, "b^c");
        CalculatorUtils.testCalculate(temp1, "(s+b)%(c*b)");
        CalculatorUtils.testCalculate(temp1, "a+(-4)");
        CalculatorUtils.testCalculate(temp1, "\u221a(c*c)");
        CalculatorUtils.testCalculate(temp1, "b\u00d7c\u00f7c");
        CalculatorUtils.testCalculate(temp1, "a+c\u221a(c*c*c)");
        CalculatorUtils.testCalculate(temp1, "b+5*b-6/c");
        CalculatorUtils.testCalculate(temp1, "(a+b+c)^b+4");
        CalculatorUtils.testCalculate(temp1, "b+5*(b-6*(c+a))/c");
        CalculatorUtils.testCalculate(temp1, "d+(5.99+6.99)*1.06^b+\u221a(a+c)");
        System.out.println("======================");
        JSONObject temp2 = JSONObject.parseObject((String)"{\"\u5546\u54c1\u91d1\u989d\": 10.25,\"\u9500\u552e\u6570\u91cf\": 10,\"\u4f18\u60e0\u91d1\u989d\":2}");
        CalculatorUtils.testCalculate(temp2, "\u5546\u54c1\u91d1\u989d*\u9500\u552e\u6570\u91cf-\u4f18\u60e0\u91d1\u989d+\u9ed8\u8ba4\u503c|5");
        System.out.println("======================");
        JSONObject temp3 = JSONObject.parseObject((String)"{\"order\":{\"product_amt\":10.25,\"num\":10}}");
        Function<String, Object> function = s -> {
            if ("random".equals(s)) {
                return Math.random();
            }
            return temp3.get(s);
        };
        CalculatorUtils.testCalculate(function, "order.product_amt * order.num + random");
        CalculatorUtils.testCalculate(function, "order.product_amt * order.num + random");
    }

    private static BigDecimal testCalculate(String str) {
        return CalculatorUtils.testCalculate(null, str);
    }

    private static BigDecimal testCalculate(Object object, String str) {
        BigDecimal result = CalculatorUtils.calculate(object, str);
        System.out.println(str + "=" + CalculatorUtils.decimalFormat(result, 2));
        return result;
    }

    public static String calculate(String str, int n) {
        BigDecimal result = CalculatorUtils.calculate(null, str);
        return CalculatorUtils.decimalFormat(result, n);
    }

    public static String calculate(Object object, String str, int n) {
        BigDecimal result = CalculatorUtils.calculate(object, str);
        return CalculatorUtils.decimalFormat(result, n);
    }

    public static BigDecimal calculate(String str) {
        return CalculatorUtils.calculate(null, str);
    }

    public static BigDecimal calculate(Object object, String str) {
        try {
            return CalculatorUtils.calcGroups(object, SplitGroupUtils.group(str, "(", ")", true));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("\u8ba1\u7b97\u5f02\u5e38\uff1a%s => %s", str, e.getMessage()), e);
        }
    }

    public static String decimalFormat(BigDecimal value, int n) {
        if (value == null) {
            return null;
        }
        String pattern = n > 0 ? "#." : "#";
        for (int i = 0; i < n && n <= 10; ++i) {
            pattern = pattern.concat("#");
        }
        return new DecimalFormat(pattern).format(value);
    }

    private static BigDecimal calcGroups(Object object, List<SplitGroupUtils.Group> list) {
        StringBuilder sb = new StringBuilder();
        for (SplitGroupUtils.Group group : list) {
            if (group.getType() == 1) {
                BigDecimal decimal = group.getChildren() != null ? CalculatorUtils.calcGroups(object, group.getChildren()) : CalculatorUtils.flatCalculate(object, group.getContext());
                sb.append(CalculatorUtils.decimalFormat(decimal, 6));
                continue;
            }
            sb.append(group.getContext());
        }
        return CalculatorUtils.flatCalculate(object, sb.toString());
    }

    private static BigDecimal flatCalculate(Object object, String eval) {
        String str = eval;
        if (str == null || "".equals(str = str.trim())) {
            return null;
        }
        int start = 0;
        int maxLevel = -1;
        Matcher matcher = OPERATOR.matcher(str);
        ValueLink pre = null;
        while (matcher.find()) {
            BigDecimal val;
            String group = matcher.group().trim();
            String leftVal = str.substring(start, matcher.start()).trim();
            Operator operator = Operator.of(group);
            BigDecimal bigDecimal = val = "".equals(leftVal) ? null : CalculatorUtils.toBigDecimal(object, leftVal);
            if (operator == null) {
                throw new RuntimeException("\u4e0d\u652f\u6301\u8fd0\u7b97\u7b26: " + group);
            }
            if (val == null && !operator.leftNullable) {
                if (StringUtils.isNotEmpty((CharSequence)leftVal)) {
                    throw new RuntimeException("\u201c" + leftVal + "\u201d \u672a\u77e5");
                }
                throw new RuntimeException("\u4e0d\u652f\u6301\u5355\u72ec\u8fd0\u7b97\uff1a" + group);
            }
            ValueLink valueLink = new ValueLink(val, operator, null);
            valueLink.pre = pre;
            if (pre != null) {
                pre.next = valueLink;
                pre.right = valueLink.left;
            }
            pre = valueLink;
            if (operator.level > maxLevel) {
                maxLevel = operator.level;
            }
            start = matcher.end();
        }
        if (pre == null) {
            return CalculatorUtils.toBigDecimal(object, str);
        }
        if (start >= str.length()) {
            throw new RuntimeException("\u4e0d\u80fd\u4ee5\u8fd0\u7b97\u7b26\u7ed3\u5c3e\uff1a" + eval);
        }
        String endStr = str.substring(start).trim();
        pre.right = CalculatorUtils.toBigDecimal(object, endStr);
        while (true) {
            if (pre.left == null && pre.pre != null && pre.pre.right == null) {
                pre.pre.right = pre.operator.apply(null, pre.right);
                pre.pre.next = pre.next;
            }
            if (pre.pre == null) break;
            pre = pre.pre;
        }
        return CalculatorUtils.simpleCalculate(pre, maxLevel);
    }

    private static BigDecimal toBigDecimal(Object object, String str) {
        Object result;
        if (object == null || NUMBER.matcher(str).matches()) {
            return new BigDecimal(str);
        }
        if (object instanceof BiFunction) {
            String defValue = str.contains("|") ? str.substring(str.lastIndexOf("|") + 1).trim() : null;
            result = EvalAnalysisUtils.parse(str, v -> ((BiFunction)object).apply(v, defValue));
        } else {
            result = EvalAnalysisUtils.parse(str, object);
        }
        if (result == null) {
            return null;
        }
        if (result instanceof BigDecimal) {
            return (BigDecimal)result;
        }
        return new BigDecimal(result.toString());
    }

    private static BigDecimal simpleCalculate(ValueLink link, int maxLevel) {
        while (true) {
            if (link.pre != null) {
                link = link.pre;
                continue;
            }
            if (link.next == null) break;
            int newMaxLevel = -1;
            while (true) {
                if (link.operator.level >= maxLevel) {
                    BigDecimal val = link.operator.apply(link.left, link.right);
                    if (link.pre != null) {
                        link.pre.right = val;
                        link.pre.next = link.next;
                    }
                    if (link.next != null) {
                        link.next.left = val;
                        link.next.pre = link.pre;
                    }
                } else if (link.operator.level > newMaxLevel) {
                    newMaxLevel = link.operator.level;
                }
                if (link.next == null) break;
                link = link.next;
            }
            maxLevel = newMaxLevel;
        }
        return link.operator.apply(link.left, link.right);
    }

    static class ValueLink {
        ValueLink pre;
        BigDecimal left;
        Operator operator;
        BigDecimal right;
        ValueLink next;

        ValueLink(BigDecimal left, Operator operator, BigDecimal right) {
            this.left = left;
            this.operator = operator;
            this.right = right;
        }
    }

    static enum Operator {
        ADD("+", 1, false, BigDecimal::add),
        SUBTRACT("-", 1, true, (a, b) -> a == null ? b.negate() : a.subtract((BigDecimal)b)),
        MULTIPLY("*", "\u00d7", 2, false, BigDecimal::multiply),
        DIVIDE("/", "\u00f7", 2, false, (a, b) -> a.divide((BigDecimal)b, 6, 4)),
        DIVIDE_REMAINDER("%", 2, false, (a, b) -> a.divideAndRemainder((BigDecimal)b)[1]),
        POW("^", 3, false, (a, b) -> BigDecimal.valueOf(Math.pow(a.doubleValue(), b.doubleValue()))),
        SQRT("\u221a", 3, true, (a, b) -> {
            if (a != null) {
                return BigDecimal.valueOf(Math.pow(b.doubleValue(), BigDecimal.ONE.divide((BigDecimal)a, 6, 4).doubleValue()));
            }
            return BigDecimal.valueOf(Math.sqrt(b.doubleValue()));
        });

        private int level;
        private String op1;
        private String op2;
        private boolean leftNullable;
        private BinaryOperator<BigDecimal> function;

        private Operator(String op1, int level, boolean leftNullable, BinaryOperator<BigDecimal> function) {
            this(op1, null, level, leftNullable, function);
        }

        private Operator(String op1, String op2, int level, boolean leftNullable, BinaryOperator<BigDecimal> function) {
            this.level = level;
            this.op2 = op2;
            this.leftNullable = leftNullable;
            this.op1 = Objects.requireNonNull(op1);
            this.function = Objects.requireNonNull(function);
        }

        public BigDecimal apply(BigDecimal a, BigDecimal b) {
            if (b == null) {
                throw new RuntimeException(String.format("%s \u540e\u9762\u5fc5\u987b\u4f4d\u6570\u5b57", this.op1));
            }
            if (a == null && !this.leftNullable) {
                throw new RuntimeException(String.format("\u683c\u5f0f\u9519\u8bef\uff1a%s %s", this.op1, String.valueOf(b)));
            }
            return (BigDecimal)this.function.apply(a, b);
        }

        public static Operator of(String operator) {
            if (operator == null) {
                return null;
            }
            for (Operator value : Operator.values()) {
                if (!operator.equals(value.op1) && !operator.equals(value.op2)) continue;
                return value;
            }
            return null;
        }
    }
}

