/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.dao;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class ReadWriteDataSource
extends AbstractRoutingDataSource {
    public static final String READ = "read";
    public static final String WRITE = "write";
    public static final ThreadLocal<String> THREAD_LOCAL = new ThreadLocal();
    private final String defaultKey;
    private Map<Object, Object> targetDataSources;

    public ReadWriteDataSource() {
        this.defaultKey = WRITE;
    }

    public ReadWriteDataSource(String defaultKey) {
        this.defaultKey = Objects.requireNonNull(defaultKey);
    }

    public void setRead(DataSource dataSource) {
        this.put(READ, dataSource);
    }

    public void setWrite(DataSource dataSource) {
        this.put(WRITE, dataSource);
    }

    public void put(String key, DataSource dataSource) {
        if (this.targetDataSources == null) {
            this.targetDataSources = new HashMap<Object, Object>();
        }
        this.targetDataSources.put(key, dataSource);
        this.setTargetDataSources(this.targetDataSources);
    }

    public void setTargetDataSources(Map<Object, Object> targetDataSources) {
        this.targetDataSources = targetDataSources;
        super.setTargetDataSources(targetDataSources);
    }

    protected Object determineCurrentLookupKey() {
        String key = THREAD_LOCAL.get();
        return key != null ? key : this.defaultKey;
    }

    public static String switchRead() {
        String key = THREAD_LOCAL.get();
        THREAD_LOCAL.set(READ);
        return key;
    }

    public static String switchWrite() {
        String key = THREAD_LOCAL.get();
        THREAD_LOCAL.set(WRITE);
        return key;
    }

    public static void remove() {
        THREAD_LOCAL.remove();
    }
}

