/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.dao;

import cn.veasion.project.dao.ReadWriteDataSource;
import java.util.function.Supplier;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;

public class DataSourceUtils {
    public static <T> T withTx(DataSourceTransactionManager dataSourceTransactionManager, Supplier<T> supplier) {
        String oldKey = ReadWriteDataSource.switchWrite();
        DefaultTransactionAttribute def = new DefaultTransactionAttribute();
        def.setPropagationBehavior(0);
        TransactionStatus transactionStatus = dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            T result = supplier.get();
            dataSourceTransactionManager.commit(transactionStatus);
            T t = result;
            return t;
        }
        catch (Exception e) {
            dataSourceTransactionManager.rollback(transactionStatus);
            throw e;
        }
        finally {
            ReadWriteDataSource.THREAD_LOCAL.set(oldKey);
        }
    }
}

